/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.utils.helpers;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.options.FsxOptions;
import com.osm2xp.model.options.ObjectFile;
import com.osm2xp.model.options.ObjectTagRule;
import com.osm2xp.model.options.ObjectsRulesList;
import com.osm2xp.model.options.OsmTag;
import com.osm2xp.utils.helpers.OptionsHelper;
import com.osm2xp.utils.helpers.XmlHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;

public class FsxOptionsHelper
extends OptionsHelper {
    private static FsxOptions options;
    private static final String FSX_OPTIONS_FILE_PATH;

    static {
        FSX_OPTIONS_FILE_PATH = ResourcesPlugin.getWorkspace().getRoot().getLocation() + File.separator + "fsxOptions.xml";
        if (new File(FSX_OPTIONS_FILE_PATH).exists()) {
            try {
                options = (FsxOptions)XmlHelper.loadFileFromXml(new File(FSX_OPTIONS_FILE_PATH), FsxOptions.class);
            }
            catch (Osm2xpException e) {
                Osm2xpLogger.error("Error initializing FSX options helper", e);
            }
        } else {
            options = FsxOptionsHelper.createNewFsxOptionsBean();
        }
    }

    private static FsxOptions createNewFsxOptionsBean() {
        FsxOptions result = new FsxOptions(FsxOptionsHelper.createNewObjectsRules(), null);
        return result;
    }

    public static FsxOptions getOptions() {
        return options;
    }

    private static ObjectsRulesList createNewObjectsRules() {
        ArrayList<ObjectTagRule> objectsList = new ArrayList<ObjectTagRule>();
        ObjectTagRule objectLighthouse = new ObjectTagRule(new OsmTag("man_made", "lighthouse"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("{BE7FA036-6133-48CD-B3A3-BDC339E6AB35}"));
                this.add(new ObjectFile("{8B63A054-B32E-415D-9884-258008444268}"));
                this.add(new ObjectFile("{DE00535C-5E8C-4CC0-932F-E82355A37412}"));
            }
        }, 0, true);
        objectsList.add(objectLighthouse);
        ObjectTagRule objectSilo = new ObjectTagRule(new OsmTag("man_made", "silo"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("{EF0366E8-AAFE-4DE8-A458-A61A5D7C84BB}"));
                this.add(new ObjectFile("{A5B68A08-6F53-43F2-B0DD-C38B9EF79421}"));
                this.add(new ObjectFile("{8D99C008-2B93-4A2B-A2D4-C2A75A1B2E41}"));
            }
        }, 0, true);
        objectsList.add(objectSilo);
        ObjectTagRule objectWindTurbine = new ObjectTagRule(new OsmTag("power_source", "wind"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("{F21DB452-6D9D-424D-B608-A9C34C194CC1}"));
            }
        }, 0, true);
        objectsList.add(objectWindTurbine);
        ObjectTagRule objectWaterTower = new ObjectTagRule(new OsmTag("man_made", "water_tower"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("{F2EF2CD2-539C-49C3-812D-128167D6EBB0}"));
                this.add(new ObjectFile("{567C15BF-E002-4DE9-A38C-B68C55135A8A}"));
            }
        }, 0, true);
        objectsList.add(objectWaterTower);
        ObjectTagRule objectCrane = new ObjectTagRule(new OsmTag("man_made", "crane"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("{C545A28E-E2EC-11D2-9C84-00105A0CE62A}"));
                this.add(new ObjectFile("{B2DFD078-603C-48B4-95FA-45EE25582157}"));
            }
        }, 0, true);
        objectsList.add(objectCrane);
        ObjectTagRule objectRadioTower = new ObjectTagRule(new OsmTag("tower:type", "communication"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("{79D0AD2B-C7CF-4433-9C7C-25BA72B3327F}"));
                this.add(new ObjectFile("{F4CCAF40-00A9-45B9-9412-E4873DE9CA97}"));
                this.add(new ObjectFile("{C545A290-E2EC-11D2-9C84-00105A0CE62A}"));
            }
        }, 0, true);
        objectsList.add(objectRadioTower);
        ObjectTagRule objectNuclearCentral = new ObjectTagRule(new OsmTag("generator:source", "nuclear"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("{DDA775E2-5E3E-435E-9A11-F5A8ECF75D37}"));
            }
        }, 0, true);
        objectsList.add(objectNuclearCentral);
        ObjectTagRule objectPowerPole = new ObjectTagRule(new OsmTag("power", "pole"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("{54382EC5-B1BD-4A43-AA1A-4F5F529356C3}"));
            }
        }, 0, true);
        objectsList.add(objectPowerPole);
        ObjectTagRule objectStorageTank = new ObjectTagRule(new OsmTag("man_made", "storage_tank"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("{7549DBA5-8710-4C0F-BF62-324244D86C31}"));
                this.add(new ObjectFile("{DA302E05-6454-4F7A-8C6F-C5FC32A77174}"));
            }
        }, 0, true);
        objectsList.add(objectStorageTank);
        ObjectTagRule objectPowerStations = new ObjectTagRule(new OsmTag("power", "station"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("{0C0C2054-0ABB-4E86-91A1-B146C3350558}"));
                this.add(new ObjectFile("{38C55F68-D0EA-418D-8C3D-CC797B80D410}"));
            }
        }, 0, true);
        objectsList.add(objectPowerStations);
        ObjectTagRule objectBaseballStadium = new ObjectTagRule(new OsmTag("sport", "baseball"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("{0BB07FF0-7FB0-4C88-ACDF-106339FF59D3}"));
            }
        }, 0, true);
        objectsList.add(objectBaseballStadium);
        ObjectTagRule objectChurches = new ObjectTagRule(new OsmTag("place_of_worship:type", "church"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("{E75256EE-38FC-49A9-9689-A5F81BC1D2C0}"));
            }
        }, 0, true);
        objectsList.add(objectChurches);
        ObjectTagRule objectCathedrals = new ObjectTagRule(new OsmTag("place_of_worship:type", "cathedral"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("{999B34C1-09CC-4172-A314-4A9371A8A8FF}"));
            }
        }, 0, true);
        objectsList.add(objectCathedrals);
        ObjectTagRule objectMosques = new ObjectTagRule(new OsmTag("place_of_worship:type", "mosque"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("{034F8334-FEDE-427E-A025-59B140FADA56}"));
            }
        }, 0, true);
        objectsList.add(objectMosques);
        ObjectsRulesList result = new ObjectsRulesList(objectsList);
        return result;
    }

    public static void saveOptions() throws Osm2xpException {
        XmlHelper.saveToXml(FsxOptionsHelper.getOptions(), new File(FSX_OPTIONS_FILE_PATH));
    }

    public static void importObjectsRules(File file) {
    }

    public static void exportObjectsRules(File file) {
    }
}

