/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.utils.helpers;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.options.GuiOptions;
import com.osm2xp.model.osm.Tag;
import com.osm2xp.utils.helpers.XmlHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class GuiOptionsHelper {
    private static GuiOptions options;
    private static String sceneName;
    private static Tag shapefileTag;
    private static File roofColorFile;
    private static final String INTERFACE_OPTIONS_FILE_PATH;

    static {
        INTERFACE_OPTIONS_FILE_PATH = ResourcesPlugin.getWorkspace().getRoot().getLocation() + File.separator + "GuiOptions.xml";
        if (new File(INTERFACE_OPTIONS_FILE_PATH).exists()) {
            try {
                options = (GuiOptions)XmlHelper.loadFileFromXml(new File(INTERFACE_OPTIONS_FILE_PATH), GuiOptions.class);
            }
            catch (Osm2xpException e) {
                Osm2xpLogger.error("Error initializing GUI options helper", e);
            }
        } else {
            options = GuiOptionsHelper.createNewGuiOptionsBean();
        }
    }

    private static GuiOptions createNewGuiOptionsBean() {
        GuiOptions result = new GuiOptions(false, false, false, true, null, "Xplane 9", new ArrayList<String>());
        return result;
    }

    public static GuiOptions getOptions() {
        return options;
    }

    public static void setSceneName(String computeSceneName) {
        sceneName = computeSceneName;
    }

    public static String getSceneName() {
        return sceneName;
    }

    public static void saveOptions() throws Osm2xpException {
        XmlHelper.saveToXml(GuiOptionsHelper.getOptions(), new File(INTERFACE_OPTIONS_FILE_PATH));
    }

    public static void addUsedFile(String fileName) {
        if (options.getLastFiles().indexOf(fileName) == -1) {
            options.getLastFiles().add(fileName);
        }
    }

    public static void askShapeFileNature(Shell shell) {
        MessageDialog messageDialog = new MessageDialog(shell, "shapefile nature", null, "What is the nature of " + new File(GuiOptionsHelper.getOptions().getCurrentFilePath()).getName() + "?", 3, new String[]{"Buildings", "Forests"}, 1);
        shapefileTag = messageDialog.open() == 0 ? new Tag("yes", "building") : new Tag("forest", "landuse");
    }

    public static Tag getShapefileTag() {
        return shapefileTag;
    }

    public static void setShapefileTag(Tag shapefileTag) {
        GuiOptionsHelper.shapefileTag = shapefileTag;
    }

    public static File getRoofColorFile() {
        return roofColorFile;
    }

    public static void setRoofColorFile(File roofColorFile) {
        GuiOptionsHelper.roofColorFile = roofColorFile;
    }
}

