/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.utils.helpers;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.project.Coordinates;
import com.osm2xp.model.project.CoordinatesList;
import com.osm2xp.model.project.Osm2XpProject;
import java.io.File;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import math.geom2d.Point2D;

public class Osm2xpProjectHelper {
    private static Osm2XpProject osm2XpProject;
    private static File projectFile;

    public static void loadProject(String filePath) throws Osm2xpException {
        Osm2XpProject result = new Osm2XpProject();
        projectFile = new File(filePath);
        try {
            JAXBContext jc = JAXBContext.newInstance((String)Osm2XpProject.class.getPackage().getName());
            Unmarshaller u = jc.createUnmarshaller();
            result = (Osm2XpProject)u.unmarshal(projectFile);
        }
        catch (JAXBException e) {
            throw new Osm2xpException(e.getMessage());
        }
        osm2XpProject = result;
    }

    public static void saveProject() throws Osm2xpException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)Osm2XpProject.class.getPackage().getName());
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)osm2XpProject, projectFile);
        }
        catch (JAXBException jAXBException) {
            throw new Osm2xpException("Error saving project to file " + projectFile.getPath());
        }
    }

    public static void initProject(List<Point2D> tilesList, String folderPath, String osmFilePath) throws Osm2xpException {
        osm2XpProject = new Osm2XpProject();
        osm2XpProject.setCoordinatesList(new CoordinatesList());
        for (Point2D coords : tilesList) {
            Coordinates coordinates = new Coordinates();
            coordinates.setLatitude((int)coords.x);
            coordinates.setLongitude((int)coords.y);
            osm2XpProject.getCoordinatesList().getCoordinates().add(coordinates);
        }
        new File(folderPath).mkdirs();
        projectFile = new File(String.valueOf(folderPath) + File.separator + "osm2xp.project");
        osm2XpProject.setFile(osmFilePath);
        Osm2xpProjectHelper.saveProject();
    }

    public static void removeTile(Point2D coordinates) throws Osm2xpException {
        if (osm2XpProject != null) {
            for (Coordinates coords : osm2XpProject.getCoordinatesList().getCoordinates()) {
                Point2D point2d = new Point2D((double)coords.getLatitude(), (double)coords.getLongitude());
                if (point2d.x != coordinates.x || point2d.y != coordinates.y) continue;
                osm2XpProject.getCoordinatesList().getCoordinates().remove(coords);
                if (osm2XpProject.getCoordinatesList().getCoordinates().isEmpty()) {
                    projectFile.delete();
                    break;
                }
                Osm2xpProjectHelper.saveProject();
                break;
            }
        }
    }

    public static Osm2XpProject getOsm2XpProject() {
        return osm2XpProject;
    }

    public static File getProjectFile() {
        return projectFile;
    }
}

