/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.utils.helpers;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.stats.BuildingStat;
import com.osm2xp.model.stats.BuildingsStats;
import com.osm2xp.model.stats.ForestStat;
import com.osm2xp.model.stats.ForestsStats;
import com.osm2xp.model.stats.GenerationStats;
import com.osm2xp.model.stats.ObjectStat;
import com.osm2xp.model.stats.ObjectsStats;
import com.osm2xp.utils.helpers.ChartsHelper;
import com.osm2xp.utils.helpers.GuiOptionsHelper;
import com.osm2xp.utils.helpers.XplaneOptionsHelper;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import math.geom2d.Point2D;

public class StatsHelper {
    private static List<GenerationStats> statsList = new ArrayList<GenerationStats>();

    public static void RecapStats(String folderPath) throws Osm2xpException {
        if (!statsList.isEmpty()) {
            if (XplaneOptionsHelper.getOptions().isGenerateXmlStats()) {
                StatsHelper.saveRecapStats(folderPath);
            }
            if (XplaneOptionsHelper.getOptions().isGeneratePdfStats()) {
                StatsHelper.generatePdfRecapReport(folderPath);
            }
        }
    }

    private static GenerationStats getRecapStats() {
        GenerationStats result = new GenerationStats();
        result.setOsmFile(statsList.get(0).getOsmFile());
        result.setDate(statsList.get(0).getDate());
        result.setOsm2XpVersion("2.0.2");
        result.setBuildingsStats(new BuildingsStats());
        result.setForestsStats(new ForestsStats());
        result.setObjectsStats(new ObjectsStats());
        for (GenerationStats stats : statsList) {
            Object bStat;
            result.setBuildingsNumber(result.getBuildingsNumber() + stats.getBuildingsNumber());
            result.setForestsNumber(result.getForestsNumber() + stats.getForestsNumber());
            result.setObjectsNumber(result.getObjectsNumber() + stats.getObjectsNumber());
            result.setStreetlightsNumber(result.getStreetlightsNumber() + stats.getStreetlightsNumber());
            for (BuildingStat buildingStat : stats.getBuildingsStats().getBuildingStat()) {
                boolean buildingStatsPresent = false;
                for (BuildingStat resultBuildingStat : result.getBuildingsStats().getBuildingStat()) {
                    if (!resultBuildingStat.getType().equalsIgnoreCase(buildingStat.getType())) continue;
                    resultBuildingStat.setNumber(resultBuildingStat.getNumber() + buildingStat.getNumber());
                    buildingStatsPresent = true;
                }
                if (buildingStatsPresent) continue;
                bStat = new BuildingStat();
                ((BuildingStat)bStat).setType(buildingStat.getType());
                ((BuildingStat)bStat).setNumber(buildingStat.getNumber());
                result.getBuildingsStats().getBuildingStat().add((BuildingStat)bStat);
            }
            for (ObjectStat objectStat : stats.getObjectsStats().getObjectStat()) {
                boolean objectStatsPresent = false;
                for (ObjectStat resultObjectStat : result.getObjectsStats().getObjectStat()) {
                    if (!resultObjectStat.getObjectPath().equalsIgnoreCase(objectStat.getObjectPath())) continue;
                    resultObjectStat.setNumber(resultObjectStat.getNumber() + objectStat.getNumber());
                    objectStatsPresent = true;
                }
                if (objectStatsPresent) continue;
                bStat = new ObjectStat();
                ((ObjectStat)bStat).setObjectPath(objectStat.getObjectPath());
                ((ObjectStat)bStat).setNumber(objectStat.getNumber());
                result.getObjectsStats().getObjectStat().add((ObjectStat)bStat);
            }
            for (ForestStat forestStat : stats.getForestsStats().getForestStat()) {
                boolean forestStatsPresent = false;
                for (ForestStat resultForestStat : result.getForestsStats().getForestStat()) {
                    if (!resultForestStat.getForestPath().equalsIgnoreCase(forestStat.getForestPath())) continue;
                    resultForestStat.setNumber(resultForestStat.getNumber() + forestStat.getNumber());
                    forestStatsPresent = true;
                }
                if (forestStatsPresent) continue;
                bStat = new ForestStat();
                ((ForestStat)bStat).setForestPath(forestStat.getForestPath());
                ((ForestStat)bStat).setNumber(forestStat.getNumber());
                result.getForestsStats().getForestStat().add((ForestStat)bStat);
            }
        }
        return result;
    }

    public static GenerationStats initStats(File currentFile, Point2D coordinates) {
        GenerationStats stats = new GenerationStats();
        stats.setForestsStats(new ForestsStats());
        stats.setBuildingsStats(new BuildingsStats());
        stats.setObjectsStats(new ObjectsStats());
        StatsHelper.writeStatHeader(currentFile, coordinates, stats);
        return stats;
    }

    public static boolean isTileEmpty(GenerationStats stats) {
        return stats.getBuildingsNumber() + stats.getForestsNumber() + stats.getObjectsNumber() + stats.getStreetlightsNumber() == 0;
    }

    private static void writeStatHeader(File currentFile, Point2D coordinates, GenerationStats stats) {
        stats.setOsm2XpVersion("2.0.2");
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
        stats.setDate(dateFormat.format(new Date()));
        stats.setOsmFile(currentFile.getPath());
        stats.setLatitude((int)coordinates.x);
        stats.setLongitude((int)coordinates.y);
    }

    private static void addBuilding(GenerationStats generationStats) {
        generationStats.setBuildingsNumber(generationStats.getBuildingsNumber() + 1);
    }

    public static void addStreetLight(GenerationStats generationStats) {
        generationStats.setStreetlightsNumber(generationStats.getStreetlightsNumber() + 1);
    }

    private static void addForest(GenerationStats generationStats) {
        generationStats.setForestsNumber(generationStats.getForestsNumber() + 1);
    }

    private static void addObject(GenerationStats generationStats) {
        generationStats.setObjectsNumber(generationStats.getObjectsNumber() + 1);
    }

    private static ObjectStat getObjectType(String objectPath, GenerationStats generationStats) {
        for (ObjectStat objectStat : generationStats.getObjectsStats().getObjectStat()) {
            if (!objectStat.getObjectPath().equals(objectPath)) continue;
            return objectStat;
        }
        return null;
    }

    private static BuildingStat getBuildingType(String buildingType, GenerationStats generationStats) {
        for (BuildingStat buildingStat : generationStats.getBuildingsStats().getBuildingStat()) {
            if (!buildingStat.getType().equals(buildingType)) continue;
            return buildingStat;
        }
        return null;
    }

    public static void addBuildingType(String buildingType, GenerationStats generationStats) {
        BuildingStat buildingStat = StatsHelper.getBuildingType(buildingType, generationStats);
        if (buildingStat != null) {
            buildingStat.setNumber(buildingStat.getNumber() + 1);
        } else {
            BuildingStat newBuildingStat = new BuildingStat();
            newBuildingStat.setType(buildingType);
            newBuildingStat.setNumber(1);
            generationStats.getBuildingsStats().getBuildingStat().add(newBuildingStat);
        }
        StatsHelper.addBuilding(generationStats);
    }

    private static ForestStat getForestType(String forestPath, GenerationStats generationStats) {
        for (ForestStat forestStat : generationStats.getForestsStats().getForestStat()) {
            if (!forestStat.getForestPath().equals(forestPath)) continue;
            return forestStat;
        }
        return null;
    }

    public static void addForestType(String ForestPath, GenerationStats generationStats) {
        ForestStat forestStat = StatsHelper.getForestType(ForestPath, generationStats);
        if (forestStat != null) {
            forestStat.setNumber(forestStat.getNumber() + 1);
        } else {
            ForestStat newForestStat = new ForestStat();
            newForestStat.setForestPath(ForestPath);
            newForestStat.setNumber(1);
            generationStats.getForestsStats().getForestStat().add(newForestStat);
        }
        StatsHelper.addForest(generationStats);
    }

    public static void addObjectType(String objectPath, GenerationStats generationStats) {
        ObjectStat objectStat = StatsHelper.getObjectType(objectPath, generationStats);
        if (objectStat != null) {
            objectStat.setNumber(objectStat.getNumber() + 1);
        } else {
            ObjectStat newObjectStat = new ObjectStat();
            newObjectStat.setObjectPath(objectPath);
            newObjectStat.setNumber(1);
            generationStats.getObjectsStats().getObjectStat().add(newObjectStat);
        }
        StatsHelper.addObject(generationStats);
    }

    public static List<GenerationStats> getStatsList() {
        return statsList;
    }

    public static void saveStats(String folderPath, Point2D tile, GenerationStats stats) throws Osm2xpException {
        File file = new File(String.valueOf(folderPath) + File.separator + "stats" + File.separator + "stats_" + (int)tile.x + "-" + (int)tile.y + ".xml");
        try {
            JAXBContext jc = JAXBContext.newInstance((String)GenerationStats.class.getPackage().getName());
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)stats, file);
        }
        catch (JAXBException jAXBException) {
            throw new Osm2xpException("Error saving stats to file " + file.getPath());
        }
    }

    public static void saveRecapStats(String folderPath) throws Osm2xpException {
        if (!statsList.isEmpty()) {
            File file = new File(String.valueOf(folderPath) + File.separator + "stats" + File.separator + "recapStats" + ".xml");
            GenerationStats stats = StatsHelper.getRecapStats();
            try {
                JAXBContext jc = JAXBContext.newInstance((String)GenerationStats.class.getPackage().getName());
                Marshaller marshaller = jc.createMarshaller();
                marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.marshal((Object)stats, file);
            }
            catch (JAXBException jAXBException) {
                throw new Osm2xpException("Error saving stats to file " + file.getPath());
            }
        }
    }

    private static void addEmptyLine(Paragraph paragraph, int number) {
        int i = 0;
        while (i < number) {
            paragraph.add((Object)new Paragraph(" "));
            ++i;
        }
    }

    public static void generatePdfRecapReport(String folderPath) throws Osm2xpException {
        File file = new File(String.valueOf(folderPath) + File.separator + "stats" + File.separator + "recapStats.pdf");
        String title = "Osm2xp recap stats ";
        StatsHelper.generatePdfReport(file, StatsHelper.getRecapStats(), title);
    }

    public static void generatePdfReport(String folderPath, GenerationStats stats) throws Osm2xpException {
        File file = new File(String.valueOf(folderPath) + File.separator + "stats" + File.separator + "stats_" + stats.getLatitude() + "-" + stats.getLongitude() + ".pdf");
        String title = "Osm2xp report for tile " + stats.getLatitude() + "/" + stats.getLongitude();
        StatsHelper.generatePdfReport(file, stats, title);
    }

    public static void generatePdfReport(File file, GenerationStats stats, String title) throws Osm2xpException {
        try {
            Document document = new Document();
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file.getPath()));
            document.open();
            document.addTitle(title);
            document.addSubject("Osm2xp report");
            document.addKeywords("osm2xp");
            document.addAuthor("osm2xp");
            document.addCreator("osm2xp");
            Paragraph preface = new Paragraph();
            StatsHelper.addEmptyLine(preface, 1);
            preface.add((Object)new Paragraph(String.valueOf(title) + " of file " + stats.getOsmFile(), new Font(2, 18.0f, 1)));
            StatsHelper.addEmptyLine(preface, 1);
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEEE d MMMM yyyy HH:mm:ss ");
            preface.add((Object)new Paragraph("Generated by osm2xp 2.0.2 , " + dateFormat.format(new Date()), new Font(2, 12.0f, 1)));
            StatsHelper.addEmptyLine(preface, 15);
            preface.add((Object)new Paragraph("Settings: ", new Font(2, 12.0f, 5)));
            StatsHelper.addEmptyLine(preface, 1);
            preface.add((Object)new Paragraph("Output mode: " + GuiOptionsHelper.getOptions().getOutputFormat(), new Font(2, 12.0f, 0)));
            if (XplaneOptionsHelper.getOptions().isGenerateBuildings()) {
                preface.add((Object)new Paragraph("Facade set: " + XplaneOptionsHelper.getOptions().getFacadeSet(), new Font(2, 12.0f, 0)));
                preface.add((Object)new Paragraph("Facade L.O.D: " + XplaneOptionsHelper.getOptions().getFacadeLod(), new Font(2, 12.0f, 0)));
                preface.add((Object)new Paragraph("Hard buildings: " + XplaneOptionsHelper.getOptions().isHardBuildings(), new Font(2, 12.0f, 0)));
                preface.add((Object)new Paragraph("Package facades files: " + XplaneOptionsHelper.getOptions().isPackageFacades(), new Font(2, 12.0f, 0)));
                StatsHelper.addEmptyLine(preface, 3);
            }
            preface.add((Object)new Paragraph("Global stats: ", new Font(2, 12.0f, 5)));
            StatsHelper.addEmptyLine(preface, 1);
            if (XplaneOptionsHelper.getOptions().isGenerateBuildings()) {
                preface.add((Object)new Paragraph("Number of generated buildings: " + stats.getBuildingsNumber(), new Font(2, 12.0f, 0)));
            }
            if (XplaneOptionsHelper.getOptions().isGenerateFor()) {
                preface.add((Object)new Paragraph("Number of generated forests: " + stats.getForestsNumber(), new Font(2, 12.0f, 0)));
            }
            if (XplaneOptionsHelper.getOptions().isGenerateObj()) {
                preface.add((Object)new Paragraph("Number of generated objects: " + stats.getObjectsNumber(), new Font(2, 12.0f, 0)));
            }
            if (XplaneOptionsHelper.getOptions().isGenerateStreetLights()) {
                preface.add((Object)new Paragraph("Number of generated streetLights: " + stats.getStreetlightsNumber(), new Font(2, 12.0f, 0)));
            }
            document.add((Element)preface);
            document.newPage();
            PdfContentByte pdfContentByte = writer.getDirectContent();
            PdfTemplate pdfTemplateChartHolder = pdfContentByte.createTemplate(500.0f, 500.0f);
            Graphics2D graphicsChart = pdfTemplateChartHolder.createGraphics(500.0f, 500.0f, (FontMapper)new DefaultFontMapper());
            Rectangle2D.Double chartRegion = new Rectangle2D.Double(0.0, 0.0, 500.0, 500.0);
            ChartsHelper.getRecapPieChart(stats).draw(graphicsChart, (Rectangle2D)chartRegion);
            graphicsChart.dispose();
            Image chartImage = Image.getInstance((PdfTemplate)pdfTemplateChartHolder);
            document.add((Element)chartImage);
            if (XplaneOptionsHelper.getOptions().isGenerateBuildings() && stats.getBuildingsNumber() > 0) {
                document.newPage();
                pdfTemplateChartHolder = pdfContentByte.createTemplate(500.0f, 500.0f);
                graphicsChart = pdfTemplateChartHolder.createGraphics(500.0f, 500.0f, (FontMapper)new DefaultFontMapper());
                chartRegion = new Rectangle2D.Double(0.0, 0.0, 500.0, 500.0);
                ChartsHelper.getBuildingsPieChart(stats).draw(graphicsChart, (Rectangle2D)chartRegion);
                graphicsChart.dispose();
                chartImage = Image.getInstance((PdfTemplate)pdfTemplateChartHolder);
                document.add((Element)chartImage);
            }
            if (XplaneOptionsHelper.getOptions().isGenerateObj() && stats.getObjectsNumber() > 0) {
                document.newPage();
                pdfTemplateChartHolder = pdfContentByte.createTemplate(500.0f, 500.0f);
                graphicsChart = pdfTemplateChartHolder.createGraphics(500.0f, 500.0f, (FontMapper)new DefaultFontMapper());
                chartRegion = new Rectangle2D.Double(0.0, 0.0, 500.0, 500.0);
                ChartsHelper.getObjectsPieChart(stats).draw(graphicsChart, (Rectangle2D)chartRegion);
                graphicsChart.dispose();
                chartImage = Image.getInstance((PdfTemplate)pdfTemplateChartHolder);
                document.add((Element)chartImage);
                document.newPage();
            }
            if (XplaneOptionsHelper.getOptions().isGenerateFor() && stats.getForestsNumber() > 0) {
                document.newPage();
                pdfTemplateChartHolder = pdfContentByte.createTemplate(500.0f, 500.0f);
                graphicsChart = pdfTemplateChartHolder.createGraphics(500.0f, 500.0f, (FontMapper)new DefaultFontMapper());
                chartRegion = new Rectangle2D.Double(0.0, 0.0, 500.0, 500.0);
                ChartsHelper.getForestsPieChart(stats).draw(graphicsChart, (Rectangle2D)chartRegion);
                graphicsChart.dispose();
                chartImage = Image.getInstance((PdfTemplate)pdfTemplateChartHolder);
                document.add((Element)chartImage);
            }
            document.close();
        }
        catch (BadElementException e) {
            throw new Osm2xpException(e.getMessage());
        }
        catch (DocumentException e) {
            throw new Osm2xpException(e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new Osm2xpException(e.getMessage());
        }
    }
}

