/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.utils.helpers;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.options.WavefrontOptions;
import com.osm2xp.utils.helpers.XmlHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;

public class WavefrontOptionsHelper {
    private static WavefrontOptions options;
    private static final String WAVEFRONT_OPTIONS_FILE_PATH;

    static {
        WAVEFRONT_OPTIONS_FILE_PATH = ResourcesPlugin.getWorkspace().getRoot().getLocation() + File.separator + "wavefrontOptions.xml";
        if (new File(WAVEFRONT_OPTIONS_FILE_PATH).exists()) {
            try {
                options = (WavefrontOptions)XmlHelper.loadFileFromXml(new File(WAVEFRONT_OPTIONS_FILE_PATH), WavefrontOptions.class);
            }
            catch (Osm2xpException e) {
                Osm2xpLogger.error("Error initializing Wavefront options helper", e);
            }
        } else {
            options = WavefrontOptionsHelper.createNewWavefrontOptionsBean();
        }
    }

    private static WavefrontOptions createNewWavefrontOptionsBean() {
        WavefrontOptions result = new WavefrontOptions(40, 40, false, true);
        return result;
    }

    public static WavefrontOptions getOptions() {
        return options;
    }
}

