/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.utils.helpers;

import com.osm2xp.exceptions.Osm2xpException;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class XmlHelper {
    public static void saveToXml(Object bean, File file) throws Osm2xpException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)bean.getClass().getPackage().getName());
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            JAXBElement jaxbElement = new JAXBElement(new QName("", bean.getClass().getSimpleName()), bean.getClass(), bean);
            marshaller.marshal((Object)jaxbElement, file);
        }
        catch (JAXBException e) {
            throw new Osm2xpException(e.getMessage());
        }
    }

    public static Object loadFileFromXml(File file, Class<?> type) throws Osm2xpException {
        Object result = new Object();
        try {
            JAXBContext jc = JAXBContext.newInstance((String)type.getPackage().getName());
            Unmarshaller u = jc.createUnmarshaller();
            JAXBElement root = u.unmarshal((Source)new StreamSource(file), type);
            if (!root.getName().getLocalPart().equalsIgnoreCase(type.getSimpleName())) {
                throw new Osm2xpException("File " + file.getName() + " is not of type " + type.getSimpleName());
            }
            result = root.getValue();
        }
        catch (JAXBException e) {
            throw new Osm2xpException(e.getMessage());
        }
        return result;
    }
}

