/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.utils.helpers;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.model.options.BuildingsExclusionsList;
import com.osm2xp.model.options.FacadesRulesList;
import com.osm2xp.model.options.ForestTagRule;
import com.osm2xp.model.options.ForestsRulesList;
import com.osm2xp.model.options.ObjectFile;
import com.osm2xp.model.options.ObjectTagRule;
import com.osm2xp.model.options.ObjectsList;
import com.osm2xp.model.options.ObjectsRulesList;
import com.osm2xp.model.options.OsmTag;
import com.osm2xp.model.options.XplaneOptions;
import com.osm2xp.utils.helpers.OptionsHelper;
import com.osm2xp.utils.helpers.XmlHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;

public class XplaneOptionsHelper
extends OptionsHelper {
    private static XplaneOptions options;
    private static final String XPLANE_OPTIONS_FILE_PATH;

    static {
        XPLANE_OPTIONS_FILE_PATH = ResourcesPlugin.getWorkspace().getRoot().getLocation() + File.separator + "xplaneOptions.xml";
        if (new File(XPLANE_OPTIONS_FILE_PATH).exists()) {
            try {
                options = (XplaneOptions)XmlHelper.loadFileFromXml(new File(XPLANE_OPTIONS_FILE_PATH), XplaneOptions.class);
            }
            catch (Osm2xpException e) {
                Osm2xpLogger.error("Error initializing Xplane options helper", e);
            }
        } else {
            options = XplaneOptionsHelper.createNewXplaneOptionsBean();
        }
    }

    public static XplaneOptions getOptions() {
        return options;
    }

    private static XplaneOptions createNewXplaneOptionsBean() {
        XplaneOptions result = new XplaneOptions();
        result.setBuildingMax(30);
        result.setBuildingMin(10);
        result.setResidentialMax(15);
        result.setResidentialMin(6);
        result.setExcludeFor(true);
        result.setExcludeObj(true);
        result.setFacadeLod(25000);
        result.setGenerateBuildings(true);
        result.setGenerateFor(true);
        result.setGeneratePdfStats(true);
        result.setGenerateSlopedRoofs(true);
        result.setGenerateObj(true);
        result.setPackageFacades(true);
        result.setBuildingsExclusions(XplaneOptionsHelper.createNewXplaneExclusions());
        result.setForestsRules(XplaneOptionsHelper.createNewForestRules());
        result.setObjectsRules(XplaneOptionsHelper.createNewObjectsRules());
        result.setStreetLightObjects(XplaneOptionsHelper.createNewStreetLightsObjects());
        result.setFacadesRules(new FacadesRulesList());
        return result;
    }

    private static ObjectsList createNewStreetLightsObjects() {
        ArrayList<ObjectFile> objectFiles = new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("opensceneryx/objects/furniture/lights/flood.obj"));
                this.add(new ObjectFile("opensceneryx/objects/furniture/lights/street/2.obj"));
            }
        };
        ObjectsList result = new ObjectsList((List<ObjectFile>)objectFiles);
        return result;
    }

    private static ObjectsRulesList createNewObjectsRules() {
        ArrayList<ObjectTagRule> objectTagRules = new ArrayList<ObjectTagRule>();
        objectTagRules.add(new ObjectTagRule(new OsmTag("power_source", "wind"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("opensceneryx/objects/buildings/industrial/wind_turbines/large.obj"));
            }
        }, 0, true));
        objectTagRules.add(new ObjectTagRule(new OsmTag("man_made", "lighthouse"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("opensceneryx/objects/buildings/marine/lighthouses/1.obj"));
            }
        }, 0, true));
        objectTagRules.add(new ObjectTagRule(new OsmTag("man_made", "water_tower"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("opensceneryx/objects/buildings/industrial/water_towers/cylindrical/1.obj"));
                this.add(new ObjectFile("opensceneryx/objects/buildings/industrial/water_towers/cylindrical/2.obj"));
            }
        }, 0, true));
        objectTagRules.add(new ObjectTagRule(new OsmTag("man_made", "crane"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("opensceneryx/objects/buildings/industrial/cranes/1.obj"));
            }
        }, 0, true));
        ObjectsRulesList result = new ObjectsRulesList(objectTagRules);
        return result;
    }

    private static BuildingsExclusionsList createNewXplaneExclusions() {
        ArrayList<OsmTag> exclusionsList = new ArrayList<OsmTag>();
        exclusionsList.add(new OsmTag("aeroway", "hangar"));
        exclusionsList.add(new OsmTag("aeroway", "terminal"));
        BuildingsExclusionsList result = new BuildingsExclusionsList(exclusionsList);
        return result;
    }

    private static ForestsRulesList createNewForestRules() {
        ArrayList<ForestTagRule> forestsRules = new ArrayList<ForestTagRule>();
        forestsRules.add(new ForestTagRule(new OsmTag("landuse", "forest"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("opensceneryx/forests/trees/europe/continental/mixed.for"));
                this.add(new ObjectFile("opensceneryx/forests/trees/europe/continental/conifer.for"));
                this.add(new ObjectFile("opensceneryx/forests/trees/europe/continental/broad_leaf.for"));
            }
        }, 255));
        forestsRules.add(new ForestTagRule(new OsmTag("natural", "wood"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("opensceneryx/forests/trees/europe/continental/mixed.for"));
                this.add(new ObjectFile("opensceneryx/forests/trees/europe/continental/conifer.for"));
                this.add(new ObjectFile("opensceneryx/forests/trees/europe/continental/broad_leaf.for"));
            }
        }, 255));
        forestsRules.add(new ForestTagRule(new OsmTag("leisure", "garden"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("opensceneryx/forests/trees/europe/continental/heathland.for"));
                this.add(new ObjectFile("opensceneryx/forests/trees/europe/continental/sclerophyllous.for"));
                this.add(new ObjectFile("opensceneryx/forests/trees/europe/continental/conifer.for"));
            }
        }, 255));
        forestsRules.add(new ForestTagRule(new OsmTag("leisure", "park"), (List<ObjectFile>)new ArrayList<ObjectFile>(){
            {
                this.add(new ObjectFile("opensceneryx/forests/trees/europe/continental/heathland.for"));
                this.add(new ObjectFile("opensceneryx/forests/trees/europe/continental/sclerophyllous.for"));
                this.add(new ObjectFile("opensceneryx/forests/trees/europe/continental/conifer.for"));
            }
        }, 255));
        ForestsRulesList result = new ForestsRulesList(forestsRules);
        return result;
    }

    public static void saveOptions() throws Osm2xpException {
        XmlHelper.saveToXml(XplaneOptionsHelper.getOptions(), new File(XPLANE_OPTIONS_FILE_PATH));
    }

    public static void importExclusions(File file) {
        try {
            Object result = XmlHelper.loadFileFromXml(file, BuildingsExclusionsList.class);
            XplaneOptionsHelper.getOptions().setBuildingsExclusions((BuildingsExclusionsList)result);
        }
        catch (Osm2xpException e) {
            Osm2xpLogger.error("Error importing exclusion file", e);
        }
    }

    public static void importFacadesRules(File file) {
        try {
            Object result = XmlHelper.loadFileFromXml(file, FacadesRulesList.class);
            XplaneOptionsHelper.getOptions().setFacadesRules((FacadesRulesList)result);
        }
        catch (Osm2xpException e) {
            Osm2xpLogger.error("Error importing facades rules file", e);
        }
    }

    public static void importForestsRules(File file) {
        try {
            Object result = XmlHelper.loadFileFromXml(file, ForestsRulesList.class);
            XplaneOptionsHelper.getOptions().setForestsRules((ForestsRulesList)result);
        }
        catch (Osm2xpException e) {
            Osm2xpLogger.error("Error importing forests rules file", e);
        }
    }

    public static void importObjectsRules(File file) {
        try {
            Object result = XmlHelper.loadFileFromXml(file, ObjectsRulesList.class);
            XplaneOptionsHelper.getOptions().setObjectsRules((ObjectsRulesList)result);
        }
        catch (Osm2xpException e) {
            Osm2xpLogger.error("Error importing objects rules file", e);
        }
    }

    public static void importStreetLightObjects(File file) {
        try {
            Object result = XmlHelper.loadFileFromXml(file, ObjectsList.class);
            XplaneOptionsHelper.getOptions().setStreetLightObjects((ObjectsList)result);
        }
        catch (Osm2xpException e) {
            Osm2xpLogger.error("Error importing street lights file", e);
        }
    }
}

