/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.utils.logging;

import com.osm2xp.utils.logging.Osm2xpConsoleLoggerFormater;
import com.osm2xp.utils.logging.Osm2xpFileLoggerFormater;
import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import org.eclipse.core.resources.ResourcesPlugin;

public class Osm2xpLogger {
    private static final String ERROR_LOG_PATH = ResourcesPlugin.getWorkspace().getRoot().getLocation() + File.separator + "error.log";
    private static Logger logger = Logger.getLogger(Osm2xpLogger.class.getName());
    private static Logger logger2;
    private static Logger errorFileLogger;

    static {
        logger.setUseParentHandlers(false);
        logger2 = Logger.getLogger("org.eclipse.equinox.logger");
        logger2.setUseParentHandlers(false);
        ConsoleHandler ch = new ConsoleHandler();
        ch.setFormatter(new Osm2xpConsoleLoggerFormater());
        logger.addHandler(ch);
        logger2.addHandler(ch);
        FileHandler fileHandler = null;
        try {
            fileHandler = new FileHandler(ERROR_LOG_PATH);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        errorFileLogger = Logger.getLogger(String.valueOf(Osm2xpLogger.class.getName()) + "-error");
        errorFileLogger.setUseParentHandlers(false);
        fileHandler.setFormatter(new Osm2xpFileLoggerFormater());
        errorFileLogger.addHandler(fileHandler);
    }

    public static void error(String message, Throwable exception) {
        logger.severe(String.valueOf(message) + "\n" + exception.getMessage());
        errorFileLogger.severe(String.valueOf(message) + "\n" + exception.getMessage());
    }

    public static void warning(String message, Throwable exception) {
        logger.warning(String.valueOf(message) + "\n" + exception.getMessage());
    }

    public static void info(String message) {
        logger.info(message);
    }

    public static void warning(String message) {
        logger.warning(message);
    }

    public static void displayWelcomeMessage() {
        logger.info("==================================================");
        logger.info("Osm2XP 2.0.2 by Benjamin Blanchet");
        logger.info("check last osm2xp news on http://osm2xp.com");
        logger.info("===================================================");
    }

    public static void error(String message) {
        logger.severe(message);
    }
}

