/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.writers.impl;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.utils.FilesUtils;
import com.osm2xp.utils.helpers.FsxOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import com.osm2xp.writers.IWriter;
import java.io.File;
import java.io.IOException;
import math.geom2d.Point2D;

public class BglWriterImpl
implements IWriter {
    private File currentBglFile;
    private String sceneFolder;

    public BglWriterImpl(String sceneFolder) {
        this.sceneFolder = sceneFolder;
    }

    private void compileBgl() {
        try {
            Runtime runtime = Runtime.getRuntime();
            runtime.exec(new String[]{FsxOptionsHelper.getOptions().getBglCompPath(), this.currentBglFile.getPath()});
            this.currentBglFile.deleteOnExit();
        }
        catch (IOException e) {
            Osm2xpLogger.error("Error on .bgl compilation.", e);
        }
    }

    private void writeBglHeader() {
        String bglHeader = "<FSData version=\"9.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"bglcomp.xsd\">";
        FilesUtils.writeTextToFile(this.currentBglFile, bglHeader, true);
    }

    @Override
    public void init(Point2D coordinates) throws Osm2xpException {
        this.currentBglFile = new File(String.valueOf(this.sceneFolder) + File.separator + "osm2xp_" + coordinates.x + "_" + coordinates.y + ".xml");
        this.writeBglHeader();
    }

    @Override
    public void write(Object data) {
        FilesUtils.writeTextToFile(this.currentBglFile, "\n" + (String)data, true);
    }

    @Override
    public void complete() {
        FilesUtils.writeTextToFile(this.currentBglFile, "\n</FSData>", true);
        this.compileBgl();
    }
}

