/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.writers.impl;

import com.osm2xp.constants.Osm2xpConstants;
import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.utils.DsfObjectsProvider;
import com.osm2xp.utils.DsfUtils;
import com.osm2xp.utils.FilesUtils;
import com.osm2xp.utils.helpers.XplaneOptionsHelper;
import com.osm2xp.utils.logging.Osm2xpLogger;
import com.osm2xp.writers.IWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import math.geom2d.Point2D;

public class DsfWriterImpl
implements IWriter {
    private static final String DEFAULT_FACADE_LOD = "LOD 0.000000 25000.000000";
    private String sceneFolder;
    private FileWriter writer = null;
    private BufferedWriter output;
    private String pathFichierTxt;
    private DsfObjectsProvider dsfObjectsProvider;

    public DsfWriterImpl(String sceneFolder, DsfObjectsProvider dsfObjectsProvider) {
        this.sceneFolder = sceneFolder;
        this.dsfObjectsProvider = dsfObjectsProvider;
    }

    public void writeLibraryFile() throws Osm2xpException {
        BufferedWriter outputlibrary = null;
        try {
            FileWriter writerLibrary = new FileWriter(String.valueOf(this.sceneFolder) + File.separatorChar + "library.txt", false);
            outputlibrary = new BufferedWriter(writerLibrary);
            outputlibrary.write("I\n");
            outputlibrary.write("800\n");
            outputlibrary.write("LIBRARY\n");
            for (String facade : this.dsfObjectsProvider.getFacadesList()) {
                outputlibrary.write("EXPORT \\lib\\osm2xp\\facades\\" + facade + " .." + File.separator + "osm2xpFacades" + File.separator + XplaneOptionsHelper.getOptions().getFacadeSet() + File.separator + facade + "\n");
            }
            outputlibrary.flush();
        }
        catch (IOException e) {
            throw new Osm2xpException(e.getMessage());
        }
    }

    @Override
    public void write(Object data) {
        if (data != null) {
            try {
                this.output.write((String)data);
                this.output.flush();
            }
            catch (IOException e) {
                Osm2xpLogger.error("Error writing data", e);
            }
        }
    }

    @Override
    public void complete() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            Osm2xpLogger.error("Error closing writer", e);
        }
        DsfUtils.textToDsf(new File(String.valueOf(this.pathFichierTxt) + ".dsf.txt"), new File(String.valueOf(this.pathFichierTxt) + ".dsf"));
    }

    @Override
    public void init(Point2D coordinates) throws Osm2xpException {
        String[] folderAndFileNames = DsfUtils.getFolderAndFileNames(coordinates);
        String nomFichier = folderAndFileNames[1];
        String nomRepertoire = folderAndFileNames[0];
        String repertoireDsf = String.valueOf(this.sceneFolder) + File.separatorChar + "Earth nav data" + File.separatorChar + nomRepertoire;
        new File(repertoireDsf).mkdirs();
        if (XplaneOptionsHelper.getOptions().isGeneratePdfStats() || XplaneOptionsHelper.getOptions().isGenerateXmlStats()) {
            new File(String.valueOf(this.sceneFolder) + File.separatorChar + "stats").mkdirs();
        }
        if (XplaneOptionsHelper.getOptions().isPackageFacades()) {
            this.copyFacadeSet();
        }
        String nomFichierTuile = String.valueOf(repertoireDsf) + File.separatorChar + nomFichier;
        try {
            this.writer = new FileWriter(String.valueOf(nomFichierTuile) + ".dsf.txt", false);
            new File(String.valueOf(nomFichierTuile) + ".dsf.txt").deleteOnExit();
            this.output = new BufferedWriter(this.writer);
            this.pathFichierTxt = nomFichierTuile;
        }
        catch (IOException e) {
            throw new Osm2xpException(e.getMessage());
        }
        if (!XplaneOptionsHelper.getOptions().isPackageFacades()) {
            this.writeLibraryFile();
        }
        this.write(DsfUtils.getDsfHeader(coordinates, this.dsfObjectsProvider));
    }

    private void copyFacadeSet() throws Osm2xpException {
        if (XplaneOptionsHelper.getOptions().isPackageFacades() && !new File(String.valueOf(this.sceneFolder) + File.separatorChar + "facades").exists()) {
            File from = new File(String.valueOf(Osm2xpConstants.FACADES_SETS_PATH) + File.separatorChar + XplaneOptionsHelper.getOptions().getFacadeSet());
            File to = new File(String.valueOf(this.sceneFolder) + File.separatorChar + "facades");
            try {
                FilesUtils.copyDirectory(from, to);
                this.applyFacadeLod(to);
                if (!XplaneOptionsHelper.getOptions().isHardBuildings()) {
                    this.removeConcreteRoofsAndWalls(to);
                }
            }
            catch (FileNotFoundException e) {
                throw new Osm2xpException(e.getMessage());
            }
            catch (IOException e) {
                throw new Osm2xpException(e.getMessage());
            }
        }
    }

    private void applyFacadeLod(File to) throws FileNotFoundException, IOException {
        File[] filesList = to.listFiles();
        if (filesList != null) {
            int cpt = 0;
            while (cpt < filesList.length) {
                if (filesList[cpt].getName().toLowerCase().contains(".fac")) {
                    File facade = filesList[cpt];
                    String line = null;
                    String facadeContent = new String();
                    RandomAccessFile reader = new RandomAccessFile(facade, "rw");
                    while ((line = reader.readLine()) != null) {
                        facadeContent = String.valueOf(facadeContent) + line + "\r\n";
                    }
                    facadeContent = facadeContent.replaceAll(DEFAULT_FACADE_LOD, "LOD 0.000000 " + XplaneOptionsHelper.getOptions().getFacadeLod() + ".000000");
                    FileWriter writer = new FileWriter(facade.getAbsolutePath());
                    writer.write(facadeContent);
                    writer.close();
                }
                ++cpt;
            }
        }
    }

    private void removeConcreteRoofsAndWalls(File to) throws FileNotFoundException, IOException {
        File[] filesList = to.listFiles();
        if (filesList != null) {
            int cpt = 0;
            while (cpt < filesList.length) {
                if (filesList[cpt].getName().toLowerCase().contains(".fac")) {
                    File facade = filesList[cpt];
                    String line = null;
                    String facadeContent = new String();
                    RandomAccessFile reader = new RandomAccessFile(facade, "rw");
                    while ((line = reader.readLine()) != null) {
                        facadeContent = String.valueOf(facadeContent) + line + "\r\n";
                    }
                    facadeContent = facadeContent.replaceAll("HARD_ROOF concrete", "");
                    facadeContent = facadeContent.replaceAll("HARD_WALL concrete", "");
                    FileWriter writer = new FileWriter(facade.getAbsolutePath());
                    writer.write(facadeContent);
                    writer.close();
                }
                ++cpt;
            }
        }
    }
}

