/*
 * Decompiled with CFR 0.152.
 */
package com.osm2xp.writers.impl;

import com.osm2xp.exceptions.Osm2xpException;
import com.osm2xp.utils.logging.Osm2xpLogger;
import com.osm2xp.writers.IWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import math.geom2d.Point2D;

public class OsmWriterImpl
implements IWriter {
    private String sceneFolder;
    private BufferedWriter output;

    public OsmWriterImpl(String sceneFolder) {
        this.sceneFolder = sceneFolder;
    }

    @Override
    public void init(Point2D coordinates) throws Osm2xpException {
        try {
            new File(this.sceneFolder).mkdirs();
            String fileName = String.valueOf(this.sceneFolder) + File.separator + coordinates.x + "_" + coordinates.y + ".osm";
            this.output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8"));
            this.writerHeader();
        }
        catch (IOException e) {
            Osm2xpLogger.error("Error initializing writer.", e);
        }
    }

    private void writerHeader() {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write("<osm version=\"0.6\" generator=\"osm2xp 2.0.2\">\n");
    }

    private void writerFooter() {
        this.write("</osm>");
    }

    @Override
    public void write(Object data) {
        if (data != null) {
            try {
                this.output.write((String)data);
                this.output.flush();
            }
            catch (IOException e) {
                Osm2xpLogger.error("Error writing data", e);
            }
        }
    }

    @Override
    public void complete() {
        this.writerFooter();
    }
}

