/*
 * Decompiled with CFR 0.152.
 */
package Tuple;

import Tuple.Tuple3f;

public class OrthonormalBasis {
    Tuple3f normal;
    Tuple3f tangent2 = new Tuple3f();
    Tuple3f tangent3;

    public OrthonormalBasis(Tuple3f normal) {
        this.normal = normal.getCopy();
        if (Math.abs(normal.x) < Math.abs(normal.y) && Math.abs(normal.x) < Math.abs(normal.z)) {
            this.tangent2.x = 0.0f;
            this.tangent2.y = normal.z;
            this.tangent2.z = -normal.y;
        } else if (Math.abs(normal.y) < Math.abs(normal.z)) {
            this.tangent2.x = normal.z;
            this.tangent2.y = 0.0f;
            this.tangent2.z = -normal.x;
        } else {
            this.tangent2.x = normal.y;
            this.tangent2.y = -normal.x;
            this.tangent2.z = 0.0f;
        }
        this.tangent3 = normal.cross(this.tangent2);
    }

    public Tuple3f localToWorld(Tuple3f dir) {
        Tuple3f toRet = new Tuple3f();
        toRet.x = this.tangent3.x * dir.x + this.tangent2.x * dir.y + this.normal.x * dir.z;
        toRet.y = this.tangent3.y * dir.x + this.tangent2.y * dir.y + this.normal.y * dir.z;
        toRet.z = this.tangent3.z * dir.x + this.tangent2.z * dir.y + this.normal.z * dir.z;
        return toRet;
    }

    public Tuple3f worldToLocal(Tuple3f dir) {
        return new Tuple3f(this.tangent3.dot(dir), this.tangent2.dot(dir), this.normal.dot(dir));
    }
}

