/*
 * Decompiled with CFR 0.152.
 */
package Tuple;

public class Tuple3f {
    public float x = 0.0f;
    public float y = 0.0f;
    public float z = 0.0f;

    public Tuple3f() {
    }

    public float getAxis(int axis) {
        switch (axis) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        return -1.0f;
    }

    public void setAxis(int axis, float val) {
        switch (axis) {
            case 0: {
                this.x = val;
                break;
            }
            case 1: {
                this.y = val;
                break;
            }
            case 2: {
                this.z = val;
            }
        }
    }

    public Tuple3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float dot(Tuple3f a) {
        return this.x * a.x + this.y * a.y + this.z * a.z;
    }

    public Tuple3f minus(Tuple3f a) {
        return new Tuple3f(this.x - a.x, this.y - a.y, this.z - a.z);
    }

    public Tuple3f plus(Tuple3f a) {
        return new Tuple3f(this.x + a.x, this.y + a.y, this.z + a.z);
    }

    public Tuple3f times(float a) {
        return new Tuple3f(this.x * a, this.y * a, this.z * a);
    }

    public void divideEquals(float a) {
        this.x /= a;
        this.y /= a;
        this.z /= a;
    }

    public float distanceSquared(Tuple3f other) {
        return (this.x - other.x) * (this.x - other.x) + (this.y - other.y) * (this.y - other.y) + (this.z - other.z) * (this.z - other.z);
    }

    public float distance(Tuple3f other) {
        return (float)Math.sqrt((this.x - other.x) * (this.x - other.x) + (this.y - other.y) * (this.y - other.y) + (this.z - other.z) * (this.z - other.z));
    }

    public void normalize() {
        float length = 1.0f / this.getLength();
        this.x *= length;
        this.y *= length;
        this.z *= length;
    }

    public float getLength() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float getLengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void plusEquals(Tuple3f rhs) {
        this.x += rhs.x;
        this.y += rhs.y;
        this.z += rhs.z;
    }

    public void minusEquals(Tuple3f rhs) {
        this.x -= rhs.x;
        this.y -= rhs.y;
        this.z -= rhs.z;
    }

    public void timesEquals(float rhs) {
        this.x *= rhs;
        this.y *= rhs;
        this.z *= rhs;
    }

    public void cross(Tuple3f v2, Tuple3f dest) {
        dest.x = this.y * v2.z - this.z * v2.y;
        dest.y = this.z * v2.x - this.x * v2.z;
        dest.z = this.x * v2.y - this.y * v2.x;
    }

    public Tuple3f cross(Tuple3f v2) {
        return new Tuple3f(this.y * v2.z - this.z * v2.y, this.z * v2.x - this.x * v2.z, this.x * v2.y - this.y * v2.x);
    }

    public boolean greaterThan(Tuple3f rhs) {
        return this.x >= rhs.x && this.y >= rhs.y && this.z >= rhs.z;
    }

    public boolean lessThan(Tuple3f rhs) {
        return this.x <= rhs.x && this.y <= rhs.y && this.z <= rhs.z;
    }

    public Tuple3f getCopy() {
        return new Tuple3f(this.x, this.y, this.z);
    }

    public Tuple3f reflect(Tuple3f normal) {
        return this.minus(normal.times(2.0f * this.dot(normal)));
    }

    public String toString() {
        return "x:" + this.x + " y:" + this.y + " z:" + this.z;
    }

    public void rotate(Tuple3f axis, float angle) {
        Tuple3f ret = this.minus(axis.times(axis.dot(this)).times((float)Math.cos(angle)));
        ret.plusEquals(this.cross(axis).times((float)Math.sin(angle)));
        ret.plusEquals(axis.times(axis.dot(this)));
        ret.normalize();
        this.x = ret.x;
        this.y = ret.y;
        this.z = ret.z;
    }

    public void rotateZ(float theta) {
        float tx = (float)((double)this.x * Math.cos(theta) + (double)this.y * Math.sin(theta));
        this.y = (float)((double)(-this.x) * Math.sin(theta) + (double)this.y * Math.cos(theta));
        this.x = tx;
    }

    public void rotateX(float theta) {
        float tz = (float)((double)this.z * Math.cos(theta) - (double)this.y * Math.sin(theta));
        this.y = (float)((double)this.z * Math.sin(theta) + (double)this.y * Math.cos(theta));
        this.z = tz;
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }
}

