/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import java.util.ArrayList;
import org.opencarto.algo.Closure;
import org.opencarto.algo.DouglasPeuckerRamerFilter;
import org.opencarto.algo.HolesDeletion;
import org.opencarto.algo.Union;

public class BufferAggregation {
    public static Geometry get(ArrayList<Geometry> geoms, double bufferDist, double erosionDist, int qSegs, double DPThreshold) {
        ArrayList<Geometry> buffs = new ArrayList<Geometry>();
        for (Geometry geom : geoms) {
            buffs.add(BufferOp.bufferOp((Geometry)geom, (double)bufferDist, (int)qSegs));
        }
        Geometry out = Union.get(buffs);
        buffs.clear();
        out = DouglasPeuckerRamerFilter.get((Geometry)out, (double)DPThreshold);
        out = Closure.get((Geometry)out, (double)erosionDist, (int)qSegs, (int)1);
        out = DouglasPeuckerRamerFilter.get((Geometry)out, (double)DPThreshold);
        out = BufferOp.bufferOp((Geometry)out, (double)0.0);
        if (out instanceof Polygon) {
            out = HolesDeletion.get((Polygon)out);
        } else if (out instanceof MultiPolygon) {
            out = HolesDeletion.get((MultiPolygon)out);
        } else {
            return null;
        }
        return out;
    }
}

