/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Union {
    static Logger logger = Logger.getLogger(Union.class.getName());

    public static Geometry get(Collection<Geometry> geoms) {
        ArrayList<Object> geoms_ = new ArrayList<Geometry>();
        geoms_.addAll(geoms);
        final int cellSize = 1 + (int)Math.sqrt(geoms_.size());
        Comparator<Geometry> comparator = new Comparator<Geometry>(){

            @Override
            public int compare(Geometry geom1, Geometry geom2) {
                double i2;
                if (geom1 == null || geom2 == null) {
                    return 0;
                }
                Envelope env1 = geom1.getEnvelopeInternal();
                Envelope env2 = geom2.getEnvelopeInternal();
                double i1 = env1.getMinX() / (double)cellSize + (double)(cellSize * ((int)env1.getMinY() / cellSize));
                return i1 >= (i2 = env2.getMinX() / (double)cellSize + (double)(cellSize * ((int)env2.getMinY() / cellSize))) ? 1 : (i1 < i2 ? -1 : 0);
            }

            @Override
            public boolean equals(Object obj) {
                return this.equals(obj);
            }

            public int hashCode() {
                return super.hashCode();
            }
        };
        int i = 1;
        int nb = 1 + (int)(Math.log(geoms_.size()) / Math.log(4.0));
        while (geoms_.size() > 1) {
            ++i;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Union (" + i + "/" + nb + ")");
            }
            TreeSet<Geometry> treeSet = new TreeSet<Geometry>(comparator);
            treeSet.addAll(geoms_);
            geoms_ = Union.get(treeSet, 4);
        }
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        for (Geometry geometry : geoms_) {
            if (geometry instanceof Polygon) {
                polys.add((Polygon)geometry);
                continue;
            }
            if (geometry instanceof MultiPolygon) {
                MultiPolygon mp = (MultiPolygon)geometry;
                for (int k = 0; k < mp.getNumGeometries(); ++k) {
                    polys.add((Polygon)mp.getGeometryN(k));
                }
                continue;
            }
            logger.severe("Error in polygon union: geometry type not supported: " + geometry.getGeometryType());
        }
        if (polys.size() == 1) {
            return (Geometry)polys.get(0);
        }
        if (geoms_.isEmpty()) {
            return new GeometryFactory().createGeometryCollection(new Geometry[0]);
        }
        return ((Geometry)geoms_.iterator().next()).getFactory().createMultiPolygon(polys.toArray(new Polygon[0]));
    }

    private static ArrayList<Geometry> get(TreeSet<Geometry> treeSet, int groupSize) {
        ArrayList<Geometry> unions = new ArrayList<Geometry>();
        Geometry union = null;
        int i = 0;
        for (Geometry geom : treeSet) {
            if (union == null || i % groupSize == 0) {
                union = geom;
            } else {
                union = OverlayOp.union((Geometry)union, (Geometry)geom);
                if (groupSize - i % groupSize == 1) {
                    unions.add(union);
                }
            }
            ++i;
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.log(Level.FINEST, " " + i + " - " + treeSet.size() + " geometries");
        }
        if (groupSize - i % groupSize != 0) {
            unions.add(union);
        }
        return unions;
    }
}

