/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo.triangulation;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.operation.relate.RelateOp;
import com.vividsolutions.jts.triangulate.ConformingDelaunayTriangulator;
import com.vividsolutions.jts.triangulate.ConstraintVertex;
import com.vividsolutions.jts.triangulate.Segment;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdge;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeSubdivision;
import com.vividsolutions.jts.triangulate.quadedge.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opencarto.algo.triangulation.TPoint;
import org.opencarto.algo.triangulation.TPointFactory;
import org.opencarto.algo.triangulation.TSegment;
import org.opencarto.algo.triangulation.TSegmentFactory;
import org.opencarto.algo.triangulation.TTriangle;
import org.opencarto.algo.triangulation.TTriangleFactory;

public class Triangulation {
    private static Logger logger = Logger.getLogger(Triangulation.class.getName());
    private Collection<TPoint> conspts;
    private Collection<TSegment> conssegs;
    private Collection<TPoint> pts;
    private Collection<TSegment> segs;
    private Collection<TTriangle> tris;
    private TPointFactory ptF;
    private TSegmentFactory segF;
    private TTriangleFactory triF;

    public Collection<TPoint> getConstraintPoints() {
        return this.conspts;
    }

    public Collection<TSegment> getConstraintSegments() {
        return this.conssegs;
    }

    public Collection<TPoint> getPoints() {
        return this.pts;
    }

    public Collection<TSegment> getSegments() {
        return this.segs;
    }

    public Collection<TTriangle> getTriangles() {
        return this.tris;
    }

    public Triangulation(List<TPoint> conspts, TPointFactory ptF, TSegmentFactory segF, TTriangleFactory triF) {
        this(conspts, new ArrayList<TSegment>(), ptF, segF, triF);
    }

    public Triangulation(List<TPoint> conspts, Collection<TSegment> conssegs, TPointFactory ptF, TSegmentFactory segF, TTriangleFactory triF) {
        this.conspts = conspts;
        this.conssegs = conssegs;
        this.ptF = ptF;
        this.segF = segF;
        this.triF = triF;
        this.pts = new HashSet<TPoint>();
        this.segs = new HashSet<TSegment>();
        this.tris = new HashSet<TTriangle>();
    }

    public void compute() {
        this.compute(false);
    }

    public void compute(boolean buildTriangles) {
        this.compute(buildTriangles, null);
    }

    public void compute(boolean buildTriangles, Geometry geom) {
        TPoint p2;
        TPoint p1;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Triangulation");
        }
        this.getPoints().clear();
        this.getTriangles().clear();
        this.getSegments().clear();
        if (this.getConstraintPoints().size() < 2) {
            return;
        }
        if (this.getConstraintPoints().size() == 2) {
            Iterator<TPoint> it = this.getConstraintPoints().iterator();
            this.getSegments().add(this.segF.create(it.next(), it.next()));
            return;
        }
        ArrayList<ConstraintVertex> vertexes = new ArrayList<ConstraintVertex>();
        Hashtable<ConstraintVertex, TPoint> dictVertPt = new Hashtable<ConstraintVertex, TPoint>();
        for (TPoint pt : this.getConstraintPoints()) {
            ConstraintVertex cv = new ConstraintVertex(pt.getPosition());
            dictVertPt.put(cv, pt);
            vertexes.add(cv);
        }
        ArrayList<Segment> segments = new ArrayList<Segment>();
        for (TSegment seg : this.getConstraintSegments()) {
            segments.add(new Segment(seg.getPt1().getPosition(), seg.getPt2().getPosition()));
        }
        ConformingDelaunayTriangulator tri = new ConformingDelaunayTriangulator(vertexes, 1.0E-9);
        tri.setConstraints(segments, vertexes);
        tri.formInitialDelaunay();
        tri.enforceConstraints();
        QuadEdgeSubdivision subdiv = tri.getSubdivision();
        for (Object o : subdiv.getVertices(false)) {
            ConstraintVertex cv = (ConstraintVertex)o;
            TPoint p = (TPoint)dictVertPt.get(cv);
            if (p == null) {
                p = this.ptF.create(cv.getCoordinate());
            }
            this.getPoints().add(p);
        }
        GeometryFactory gf = new GeometryFactory();
        for (Object o : subdiv.getPrimaryEdges(false)) {
            QuadEdge qe = (QuadEdge)o;
            p1 = (TPoint)dictVertPt.get(qe.orig());
            p2 = (TPoint)dictVertPt.get(qe.dest());
            if (geom != null && !RelateOp.contains((Geometry)geom, (Geometry)gf.createPoint(new Coordinate((p1.getPosition().x + p2.getPosition().x) * 0.5, (p1.getPosition().y + p2.getPosition().y) * 0.5)))) continue;
            this.getSegments().add(this.segF.create(p1, p2));
        }
        if (buildTriangles) {
            return;
        }
        for (Object o : subdiv.getTriangleVertices(false)) {
            Vertex[] t = (Vertex[])o;
            p1 = (TPoint)dictVertPt.get(t[0]);
            p2 = (TPoint)dictVertPt.get(t[1]);
            TPoint p3 = (TPoint)dictVertPt.get(t[2]);
            if (geom != null && !RelateOp.contains((Geometry)geom, (Geometry)gf.createPoint(new Coordinate((p1.getPosition().x + p2.getPosition().x + p3.getPosition().x) / 3.0, (p1.getPosition().y + p2.getPosition().y + p3.getPosition().y) / 3.0)))) continue;
            this.getTriangles().add(this.triF.create(p1, p2, p3));
        }
    }
}

