/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.embedder;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.eclipse.m2e.core.embedder.ArtifactKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactRef
implements Serializable {
    private static final long serialVersionUID = -7560496230862532267L;
    private final ArtifactKey artifactKey;
    private final String scope;

    public ArtifactRef(Artifact artifact) {
        this.artifactKey = new ArtifactKey(artifact);
        this.scope = artifact.getScope();
    }

    public ArtifactKey getArtifactKey() {
        return this.artifactKey;
    }

    public String getGroupId() {
        return this.artifactKey.getGroupId();
    }

    public String getArtifactId() {
        return this.artifactKey.getArtifactId();
    }

    public String getVersion() {
        return this.artifactKey.getVersion();
    }

    public String getClassifier() {
        return this.artifactKey.getClassifier();
    }

    public String getScope() {
        return this.scope;
    }

    public static Set<ArtifactKey> toArtifactKey(Set<ArtifactRef> refs) {
        LinkedHashSet<ArtifactKey> keys = new LinkedHashSet<ArtifactKey>(refs.size());
        for (ArtifactRef ref : refs) {
            keys.add(ref.getArtifactKey());
        }
        return keys;
    }

    public static Set<ArtifactRef> fromArtifact(Set<Artifact> artifacts) {
        LinkedHashSet<ArtifactRef> refs = new LinkedHashSet<ArtifactRef>(artifacts.size());
        for (Artifact artifact : artifacts) {
            refs.add(new ArtifactRef(artifact));
        }
        return refs;
    }
}

