/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.embedder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.NearestVersionConflictResolver;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.collection.DependencyGraphTransformer;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.aether.util.filter.ScopeDependencyFilter;
import org.sonatype.aether.util.graph.CloningDependencyVisitor;
import org.sonatype.aether.util.graph.FilteringDependencyVisitor;
import org.sonatype.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.sonatype.aether.util.graph.transformer.JavaEffectiveScopeCalculator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class MavenModelManager {
    private static final Logger log = LoggerFactory.getLogger(MavenModelManager.class);
    private final IMavenProjectRegistry projectManager;
    private final IMaven maven;

    public MavenModelManager(IMaven maven, IMavenProjectRegistry projectManager) {
        this.maven = maven;
        this.projectManager = projectManager;
    }

    public Model readMavenModel(InputStream reader) throws CoreException {
        return this.maven.readModel(reader);
    }

    public Model readMavenModel(File pomFile) throws CoreException {
        return this.maven.readModel(pomFile);
    }

    public Model readMavenModel(IFile pomFile) throws CoreException {
        return this.maven.readModel(pomFile.getLocation().toFile());
    }

    public void createMavenModel(IFile pomFile, Model model) throws CoreException {
        String pomFileName = pomFile.getLocation().toString();
        if (pomFile.exists()) {
            String msg = NLS.bind((String)Messages.MavenModelManager_error_pom_exists, (Object)pomFileName);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, msg, null));
        }
        try {
            Attr attr;
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            this.maven.writeModel(model, buf);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(buf.toByteArray()));
            Element documentElement = document.getDocumentElement();
            NamedNodeMap attributes = documentElement.getAttributes();
            if (attributes == null || attributes.getNamedItem("xmlns") == null) {
                attr = document.createAttribute("xmlns");
                attr.setTextContent("http://maven.apache.org/POM/4.0.0");
                documentElement.setAttributeNode(attr);
            }
            if (attributes == null || attributes.getNamedItem("xmlns:xsi") == null) {
                attr = document.createAttribute("xmlns:xsi");
                attr.setTextContent("http://www.w3.org/2001/XMLSchema-instance");
                documentElement.setAttributeNode(attr);
            }
            if (attributes == null || attributes.getNamedItem("xsi:schemaLocation") == null) {
                attr = document.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation");
                attr.setTextContent("http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd");
                documentElement.setAttributeNode(attr);
            }
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            buf.reset();
            trans.transform(new DOMSource(document), new StreamResult(buf));
            pomFile.create((InputStream)new ByteArrayInputStream(buf.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (RuntimeException ex) {
            String msg = NLS.bind((String)Messages.MavenModelManager_error_create, (Object)pomFileName, (Object)ex.toString());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, msg, (Throwable)ex));
        }
        catch (Exception ex) {
            String msg = NLS.bind((String)Messages.MavenModelManager_error_create, (Object)pomFileName, (Object)ex.toString());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, msg, (Throwable)ex));
        }
    }

    public synchronized DependencyNode readDependencyTree(IFile file, String classpath, IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName(Messages.MavenModelManager_monitor_reading);
        MavenProject mavenProject = this.readMavenProject(file, monitor);
        return this.readDependencyTree(mavenProject, classpath, monitor);
    }

    public DependencyNode readDependencyTree(MavenProject mavenProject, String classpath, IProgressMonitor monitor) throws CoreException {
        return this.readDependencyTree(null, mavenProject, classpath, monitor);
    }

    public synchronized DependencyNode readDependencyTree(IMavenProjectFacade context, MavenProject mavenProject, String scope, IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName(Messages.MavenModelManager_monitor_building);
        IMaven maven = MavenPlugin.getMaven();
        MavenExecutionRequest executionRequest = context != null ? MavenPlugin.getMavenProjectRegistry().createExecutionRequest(context, monitor) : maven.createExecutionRequest(monitor);
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(maven.createSession(executionRequest, mavenProject).getRepositorySession());
        ChainedDependencyGraphTransformer transformer = new ChainedDependencyGraphTransformer(new DependencyGraphTransformer[]{new JavaEffectiveScopeCalculator(), new NearestVersionConflictResolver()});
        session.setDependencyGraphTransformer((DependencyGraphTransformer)transformer);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            DependencyNode node;
            Thread.currentThread().setContextClassLoader(maven.getProjectRealm(mavenProject));
            ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
            CollectRequest request = new CollectRequest();
            request.setRequestContext("project");
            request.setRepositories(mavenProject.getRemoteProjectRepositories());
            for (Dependency dependency : mavenProject.getDependencies()) {
                request.addDependency(RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)stereotypes));
            }
            DependencyManagement depMngt = mavenProject.getDependencyManagement();
            if (depMngt != null) {
                for (Dependency dependency : depMngt.getDependencies()) {
                    request.addManagedDependency(RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)stereotypes));
                }
            }
            try {
                node = MavenPluginActivator.getDefault().getRepositorySystem().collectDependencies((RepositorySystemSession)session, request).getRoot();
            }
            catch (DependencyCollectionException ex) {
                String msg = Messages.MavenModelManager_error_read;
                log.error(msg, (Throwable)ex);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, msg, (Throwable)ex));
            }
            HashSet scopes = new HashSet();
            Collections.addAll(scopes, "system", "compile", "provided", "runtime", "test");
            if ("compile".equals(scope)) {
                scopes.remove("compile");
                scopes.remove("system");
                scopes.remove("provided");
            } else if ("runtime".equals(scope)) {
                scopes.remove("compile");
                scopes.remove("runtime");
            } else if ("compile+runtime".equals(scope)) {
                scopes.remove("compile");
                scopes.remove("system");
                scopes.remove("provided");
                scopes.remove("runtime");
            } else {
                scopes.clear();
            }
            CloningDependencyVisitor cloner = new CloningDependencyVisitor();
            node.accept((DependencyVisitor)new FilteringDependencyVisitor((DependencyVisitor)cloner, (DependencyFilter)new ScopeDependencyFilter(null, scopes)));
            DependencyNode dependencyNode = node = cloner.getRootNode();
            return dependencyNode;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public MavenProject readMavenProject(IFile file, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade projectFacade = this.projectManager.create(file, true, monitor);
        MavenProject mavenProject = projectFacade.getMavenProject(monitor);
        return mavenProject;
    }
}

