/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionReader {
    private static final Logger log = LoggerFactory.getLogger(ExtensionReader.class);
    public static final String EXTENSION_ARCHETYPES = "org.eclipse.m2e.core.archetypeCatalogs";
    public static final String EXTENSION_PROJECT_CHANGED_EVENT_LISTENERS = "org.eclipse.m2e.core.mavenProjectChangedListeners";
    private static final String ELEMENT_LOCAL_ARCHETYPE = "local";
    private static final String ELEMENT_REMOTE_ARCHETYPE = "remote";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_URL = "url";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ELEMENT_LISTENER = "listener";

    public static List<ArchetypeCatalogFactory> readArchetypeExtensions() {
        ArrayList<ArchetypeCatalogFactory> archetypeCatalogs = new ArrayList<ArchetypeCatalogFactory>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint archetypesExtensionPoint = registry.getExtensionPoint(EXTENSION_ARCHETYPES);
        if (archetypesExtensionPoint != null) {
            IExtension[] archetypesExtensions;
            IExtension[] iExtensionArray = archetypesExtensions = archetypesExtensionPoint.getExtensions();
            int n = archetypesExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                IContributor contributor = extension.getContributor();
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    ArchetypeCatalogFactory factory = ExtensionReader.readArchetypeCatalogs(element, contributor);
                    archetypeCatalogs.add(factory);
                    ++n4;
                }
                ++n2;
            }
        }
        return archetypeCatalogs;
    }

    private static ArchetypeCatalogFactory readArchetypeCatalogs(IConfigurationElement element, IContributor contributor) {
        String url;
        if (ELEMENT_LOCAL_ARCHETYPE.equals(element.getName())) {
            String name = element.getAttribute(ATTR_NAME);
            if (name != null) {
                Bundle[] bundles = Platform.getBundles((String)contributor.getName(), null);
                URL catalogUrl = null;
                int i = 0;
                while (i < bundles.length) {
                    Bundle bundle = bundles[i];
                    catalogUrl = bundle.getEntry(name);
                    if (catalogUrl != null) {
                        String description = element.getAttribute(ATTR_DESCRIPTION);
                        String url2 = catalogUrl.toString();
                        return new ArchetypeCatalogFactory.RemoteCatalogFactory(url2.substring(0, url2.lastIndexOf("/")), description, false);
                    }
                    ++i;
                }
                log.error("Unable to find Archetype catalog " + name + " in " + contributor.getName());
            }
        } else if (ELEMENT_REMOTE_ARCHETYPE.equals(element.getName()) && (url = element.getAttribute(ATTR_URL)) != null) {
            String description = element.getAttribute(ATTR_DESCRIPTION);
            return new ArchetypeCatalogFactory.RemoteCatalogFactory(url, description, false);
        }
        return null;
    }

    public static List<IMavenProjectChangedListener> readProjectChangedEventListenerExtentions() {
        ArrayList<IMavenProjectChangedListener> listeners = new ArrayList<IMavenProjectChangedListener>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint mappingsExtensionPoint = registry.getExtensionPoint(EXTENSION_PROJECT_CHANGED_EVENT_LISTENERS);
        if (mappingsExtensionPoint != null) {
            IExtension[] mappingsExtensions;
            IExtension[] iExtensionArray = mappingsExtensions = mappingsExtensionPoint.getExtensions();
            int n = mappingsExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(ELEMENT_LISTENER)) {
                        try {
                            listeners.add((IMavenProjectChangedListener)element.createExecutableExtension("class"));
                        }
                        catch (CoreException ex) {
                            log.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return listeners;
    }
}

