/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal;

import java.io.File;
import org.apache.maven.archetype.Archetype;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.index.ArtifactContextProducer;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.plugin.LegacySupport;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.embedder.MavenRuntimeManager;
import org.eclipse.m2e.core.internal.ExtensionReader;
import org.eclipse.m2e.core.internal.NoSuchComponentException;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.internal.archetype.ArchetypeManager;
import org.eclipse.m2e.core.internal.embedder.MavenEmbeddedRuntime;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.core.internal.embedder.MavenWorkspaceRuntime;
import org.eclipse.m2e.core.internal.index.IndexManager;
import org.eclipse.m2e.core.internal.index.filter.ArtifactFilterManager;
import org.eclipse.m2e.core.internal.index.nexus.IndexesExtensionReader;
import org.eclipse.m2e.core.internal.index.nexus.IndexingTransferListener;
import org.eclipse.m2e.core.internal.index.nexus.NexusIndexManager;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.markers.MavenMarkerManager;
import org.eclipse.m2e.core.internal.preferences.MavenConfigurationImpl;
import org.eclipse.m2e.core.internal.project.ProjectConfigurationManager;
import org.eclipse.m2e.core.internal.project.WorkspaceStateWriter;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectManager;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryRefreshJob;
import org.eclipse.m2e.core.internal.repository.RepositoryRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.repository.IRepositoryRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositorySystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenPluginActivator
extends Plugin {
    private final Logger log = LoggerFactory.getLogger(MavenPlugin.class);
    public static final String PREFS_ARCHETYPES = "archetypesInfo.xml";
    private static MavenPluginActivator plugin;
    private MutablePlexusContainer plexus;
    private MavenModelManager modelManager;
    private NexusIndexManager indexManager;
    private BundleContext bundleContext;
    private MavenProjectManager projectManager;
    private MavenRuntimeManager runtimeManager;
    private ProjectConfigurationManager configurationManager;
    private ProjectRegistryRefreshJob mavenBackgroundJob;
    private ArchetypeManager archetypeManager;
    private ProjectRegistryManager managerImpl;
    private IMavenMarkerManager mavenMarkerManager;
    private RepositoryRegistry repositoryRegistry;
    private ArtifactFilterManager artifactFilterManager;
    private String version = "0.0.0";
    private String qualifiedVersion = "0.0.0.qualifier";
    private IMavenConfiguration mavenConfiguration;
    private BundleListener bundleListener = new BundleListener(){

        public void bundleChanged(BundleEvent event) {
            LifecycleMappingFactory.setBundleMetadataSources(null);
        }
    };
    private MavenImpl maven;

    public MavenPluginActivator() {
        plugin = this;
        if (Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.m2e.core/debug/initialization"))) {
            System.err.println("### executing constructor org.eclipse.m2e.core");
            new Throwable().printStackTrace();
        }
    }

    public IMaven getMaven() {
        return this.maven;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.m2e.core/debug/initialization"))) {
            System.err.println("### executing start() org.eclipse.m2e.core");
            new Throwable().printStackTrace();
        }
        this.bundleContext = context;
        try {
            this.qualifiedVersion = (String)this.getBundle().getHeaders().get("Bundle-Version");
            Version bundleVersion = Version.parseVersion((String)this.qualifiedVersion);
            this.version = String.valueOf(bundleVersion.getMajor()) + "." + bundleVersion.getMinor() + "." + bundleVersion.getMicro();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.mavenConfiguration = new MavenConfigurationImpl();
        ClassLoader cl = MavenPlugin.class.getClassLoader();
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(new ClassWorld("plexus.core", cl)).setName("plexus");
        this.plexus = new DefaultPlexusContainer(cc);
        File stateLocationDir = this.getStateLocation().toFile();
        this.archetypeManager = MavenPluginActivator.newArchetypeManager(stateLocationDir);
        try {
            this.archetypeManager.readCatalogs();
        }
        catch (Exception ex) {
            String msg = "Can't read archetype catalog configuration";
            this.log.error(msg, (Throwable)ex);
        }
        this.mavenMarkerManager = new MavenMarkerManager(this.mavenConfiguration);
        boolean updateProjectsOnStartup = this.mavenConfiguration.isUpdateProjectsOnStartup();
        this.maven = new MavenImpl(this.mavenConfiguration);
        this.managerImpl = new ProjectRegistryManager(this.maven, stateLocationDir, !updateProjectsOnStartup, this.mavenMarkerManager);
        this.mavenBackgroundJob = new ProjectRegistryRefreshJob(this.managerImpl, this.mavenConfiguration);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this.mavenBackgroundJob, 7);
        this.projectManager = new MavenProjectManager(this.managerImpl, this.mavenBackgroundJob, stateLocationDir);
        this.projectManager.addMavenProjectChangedListener(new WorkspaceStateWriter(this.projectManager));
        if (updateProjectsOnStartup || this.managerImpl.getProjects().length == 0) {
            this.projectManager.refresh(new MavenUpdateRequest(workspace.getRoot().getProjects(), this.mavenConfiguration.isOffline(), false));
        }
        this.modelManager = new MavenModelManager(this.maven, this.projectManager);
        this.runtimeManager = new MavenRuntimeManager();
        this.runtimeManager.setEmbeddedRuntime(new MavenEmbeddedRuntime(this.getBundleContext()));
        this.runtimeManager.setWorkspaceRuntime(new MavenWorkspaceRuntime(this.projectManager));
        this.configurationManager = new ProjectConfigurationManager(this.maven, this.managerImpl, this.modelManager, this.mavenMarkerManager, this.mavenConfiguration);
        this.projectManager.addMavenProjectChangedListener(this.configurationManager);
        workspace.addResourceChangeListener((IResourceChangeListener)this.configurationManager, 4);
        this.repositoryRegistry = new RepositoryRegistry(this.maven, this.projectManager);
        this.maven.addSettingsChangeListener(this.repositoryRegistry);
        this.projectManager.addMavenProjectChangedListener(this.repositoryRegistry);
        this.indexManager = new NexusIndexManager(this.projectManager, this.repositoryRegistry, stateLocationDir);
        this.projectManager.addMavenProjectChangedListener(this.indexManager);
        this.maven.addLocalRepositoryListener(new IndexingTransferListener(this.indexManager));
        this.repositoryRegistry.addRepositoryIndexer(this.indexManager);
        this.repositoryRegistry.addRepositoryDiscoverer(new IndexesExtensionReader(this.indexManager));
        context.addBundleListener(this.bundleListener);
        this.artifactFilterManager = new ArtifactFilterManager();
        this.repositoryRegistry.updateRegistry();
    }

    private static ArchetypeManager newArchetypeManager(File stateLocationDir) {
        ArchetypeManager archetypeManager = new ArchetypeManager(new File(stateLocationDir, PREFS_ARCHETYPES));
        archetypeManager.addArchetypeCatalogFactory(new ArchetypeCatalogFactory.NexusIndexerCatalogFactory());
        archetypeManager.addArchetypeCatalogFactory(new ArchetypeCatalogFactory.InternalCatalogFactory());
        archetypeManager.addArchetypeCatalogFactory(new ArchetypeCatalogFactory.DefaultLocalCatalogFactory());
        for (ArchetypeCatalogFactory archetypeCatalogFactory : ExtensionReader.readArchetypeExtensions()) {
            archetypeManager.addArchetypeCatalogFactory(archetypeCatalogFactory);
        }
        return archetypeManager;
    }

    public PlexusContainer getPlexusContainer() {
        return this.plexus;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.managerImpl.writeWorkspaceState();
        context.removeBundleListener(this.bundleListener);
        this.mavenBackgroundJob.cancel();
        try {
            this.mavenBackgroundJob.join();
        }
        catch (InterruptedException interruptedException) {}
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.mavenBackgroundJob);
        this.mavenBackgroundJob = null;
        this.projectManager.removeMavenProjectChangedListener(this.configurationManager);
        this.projectManager.removeMavenProjectChangedListener(this.indexManager);
        this.projectManager.removeMavenProjectChangedListener(this.repositoryRegistry);
        this.projectManager = null;
        this.plexus.dispose();
        this.maven.disposeContainer();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.configurationManager);
        this.configurationManager = null;
        LifecycleMappingFactory.setBundleMetadataSources(null);
        plugin = null;
    }

    public static MavenPluginActivator getDefault() {
        return plugin;
    }

    public MavenModelManager getMavenModelManager() {
        return this.modelManager;
    }

    public MavenProjectManager getMavenProjectManager() {
        return this.projectManager;
    }

    public ProjectRegistryManager getMavenProjectManagerImpl() {
        return this.managerImpl;
    }

    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    public MavenRuntimeManager getMavenRuntimeManager() {
        return this.runtimeManager;
    }

    public ArchetypeManager getArchetypeManager() {
        return this.archetypeManager;
    }

    public IMavenMarkerManager getMavenMarkerManager() {
        return this.mavenMarkerManager;
    }

    public IMavenConfiguration getMavenConfiguration() {
        return this.mavenConfiguration;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public IProjectConfigurationManager getProjectConfigurationManager() {
        return this.configurationManager;
    }

    public ProjectRegistryRefreshJob getProjectManagerRefreshJob() {
        return this.mavenBackgroundJob;
    }

    private <C> C lookup(Class<C> role) {
        try {
            return (C)this.plexus.lookup(role);
        }
        catch (ComponentLookupException ex) {
            throw new NoSuchComponentException(ex);
        }
    }

    private <T> T lookup(Class<T> role, String roleHint) {
        try {
            return (T)this.plexus.lookup(role, roleHint);
        }
        catch (ComponentLookupException ex) {
            throw new NoSuchComponentException(ex);
        }
    }

    public static String getVersion() {
        return MavenPluginActivator.plugin.version;
    }

    public static String getQualifiedVersion() {
        return MavenPluginActivator.plugin.qualifiedVersion;
    }

    public IRepositoryRegistry getRepositoryRegistry() {
        return this.repositoryRegistry;
    }

    public Archetype getArchetype() {
        return this.lookup(Archetype.class);
    }

    public ArchetypeDataSource getArchetypeDataSource(String hint) {
        return this.lookup(ArchetypeDataSource.class, hint);
    }

    public ArchetypeArtifactManager getArchetypeArtifactManager() {
        return this.lookup(ArchetypeArtifactManager.class);
    }

    public IndexUpdater getIndexUpdater() {
        return this.lookup(IndexUpdater.class);
    }

    public WagonManager getWagonManager() {
        return this.lookup(WagonManager.class);
    }

    public NexusIndexer getNexusIndexer() {
        return this.lookup(NexusIndexer.class);
    }

    public ArtifactContextProducer getArtifactContextProducer() {
        return this.lookup(ArtifactContextProducer.class);
    }

    public ArtifactFactory getArtifactFactory() {
        return this.lookup(ArtifactFactory.class);
    }

    public ArtifactMetadataSource getArtifactMetadataSource() {
        return this.lookup(ArtifactMetadataSource.class);
    }

    public ArtifactCollector getArtifactCollector() {
        return this.lookup(ArtifactCollector.class);
    }

    public RepositorySystem getRepositorySystem() {
        return this.lookup(RepositorySystem.class);
    }

    public MavenSession setSession(MavenSession session) {
        LegacySupport legacy = this.lookup(LegacySupport.class);
        MavenSession old = legacy.getSession();
        legacy.setSession(session);
        return old;
    }

    public ArtifactFilterManager getArifactFilterManager() {
        return this.artifactFilterManager;
    }
}

