/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.builder.AbstractEclipseBuildContext;
import org.eclipse.m2e.core.internal.builder.BuildProblemInfo;
import org.eclipse.m2e.core.internal.builder.EclipseBuildContext;
import org.eclipse.m2e.core.internal.builder.EclipseIncrementalBuildContext;
import org.eclipse.m2e.core.internal.builder.InternalBuildParticipant;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.internal.markers.SourceLocationHelper;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.ThreadBuildContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenBuilder
extends IncrementalProjectBuilder {
    private static Logger log = LoggerFactory.getLogger(MavenBuilder.class);
    public static boolean DEBUG = MavenPluginActivator.getDefault().isDebugging() & Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.m2e.core/debug/builder"));
    public static QualifiedName BUILD_CONTEXT_KEY = new QualifiedName("org.eclipse.m2e.core", "BuildContext");
    private static final String BUILD_PARTICIPANT_ID_ATTR_NAME = "buildParticipantId";
    private GetDeltaCallback getDeltaCallback = new GetDeltaCallback(){

        public IResourceDelta getDelta(IProject project) {
            return MavenBuilder.this.getDelta(project);
        }
    };

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        LinkedHashMap<Throwable, MojoExecutionKey> buildErrors;
        AbstractEclipseBuildContext buildContext;
        MavenSession session;
        HashSet<IProject> dependencies;
        MavenProject mavenProject;
        long start;
        IProject project;
        block23: {
            project = this.getProject();
            log.debug("Building project {}", (Object)project.getName());
            start = System.currentTimeMillis();
            IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
            IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
            IMavenConfiguration mavenConfiguration = MavenPlugin.getMavenConfiguration();
            IMavenMarkerManager markerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
            markerManager.deleteMarkers((IResource)project, kind == 6, "org.eclipse.m2e.core.maven2Problem.build");
            if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                return null;
            }
            IFile pomResource = project.getFile("pom.xml");
            if (pomResource == null) {
                log.error("Project {} does not have pom.xml", (Object)project.getName());
                return null;
            }
            IResourceDelta delta = this.getDelta(project);
            IMavenProjectFacade projectFacade = projectManager.create(this.getProject(), monitor);
            if (delta == null || projectFacade == null || projectFacade.isStale()) {
                MavenUpdateRequest updateRequest = new MavenUpdateRequest(project, mavenConfiguration.isOffline(), false);
                projectManager.refresh(updateRequest, monitor);
                projectFacade = projectManager.create(project, monitor);
                if (projectFacade == null) {
                    return null;
                }
            }
            mavenProject = null;
            try {
                mavenProject = projectFacade.getMavenProject(monitor);
            }
            catch (CoreException ce) {
                this.addErrorMarker((Exception)((Object)ce));
                monitor.done();
                return null;
            }
            ILifecycleMapping lifecycleMapping = configurationManager.getLifecycleMapping(projectFacade);
            if (lifecycleMapping == null) {
                return null;
            }
            dependencies = new HashSet<IProject>();
            IMaven maven = MavenPlugin.getMaven();
            MavenExecutionRequest request = projectManager.createExecutionRequest(pomResource, projectFacade.getResolverConfiguration(), monitor);
            session = maven.createSession(request, mavenProject);
            HashMap<String, Object> contextState = (HashMap<String, Object>)project.getSessionProperty(BUILD_CONTEXT_KEY);
            if (delta != null && contextState != null && (10 == kind || 9 == kind)) {
                buildContext = new EclipseIncrementalBuildContext(delta, contextState);
            } else {
                contextState = new HashMap<String, Object>();
                project.setSessionProperty(BUILD_CONTEXT_KEY, contextState);
                buildContext = new EclipseBuildContext(project, contextState);
            }
            buildErrors = new LinkedHashMap<Throwable, MojoExecutionKey>();
            ThreadBuildContext.setThreadBuildContext((BuildContext)buildContext);
            try {
                try {
                    Map<MojoExecutionKey, List<AbstractBuildParticipant>> buildParticipantsByMojoExecutionKey = lifecycleMapping.getBuildParticipants(projectFacade, monitor);
                    for (Map.Entry<MojoExecutionKey, List<AbstractBuildParticipant>> entry : buildParticipantsByMojoExecutionKey.entrySet()) {
                        for (InternalBuildParticipant internalBuildParticipant : entry.getValue()) {
                            MojoExecutionKey mojoExecutionKey = entry.getKey();
                            log.debug("Executing build participant {} for plugin execution {}", (Object)internalBuildParticipant.getClass().getName(), (Object)mojoExecutionKey.toString());
                            String stringMojoExecutionKey = mojoExecutionKey.getKeyString();
                            buildContext.setCurrentBuildParticipantId(String.valueOf(stringMojoExecutionKey) + "-" + internalBuildParticipant.getClass().getName());
                            internalBuildParticipant.setMavenProjectFacade(projectFacade);
                            internalBuildParticipant.setGetDeltaCallback(this.getDeltaCallback);
                            internalBuildParticipant.setSession(session);
                            internalBuildParticipant.setBuildContext(buildContext);
                            long executionStartTime = System.currentTimeMillis();
                            try {
                                try {
                                    Set<IProject> sub;
                                    if ((6 == kind || delta != null || internalBuildParticipant.callOnEmptyDelta()) && (sub = internalBuildParticipant.build(kind, monitor)) != null) {
                                        dependencies.addAll(sub);
                                    }
                                }
                                catch (Exception e) {
                                    log.debug("Exception in build participant {}", (Object)internalBuildParticipant.getClass().getName(), (Object)e);
                                    buildErrors.put(e, mojoExecutionKey);
                                    log.debug("Finished executing build participant {} for plugin execution {} in {} ms", new Object[]{internalBuildParticipant.getClass().getName(), mojoExecutionKey.toString(), System.currentTimeMillis() - executionStartTime});
                                    internalBuildParticipant.setMavenProjectFacade(null);
                                    internalBuildParticipant.setGetDeltaCallback(null);
                                    internalBuildParticipant.setSession(null);
                                    internalBuildParticipant.setBuildContext(null);
                                    this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                log.debug("Finished executing build participant {} for plugin execution {} in {} ms", new Object[]{internalBuildParticipant.getClass().getName(), mojoExecutionKey.toString(), System.currentTimeMillis() - executionStartTime});
                                internalBuildParticipant.setMavenProjectFacade(null);
                                internalBuildParticipant.setGetDeltaCallback(null);
                                internalBuildParticipant.setSession(null);
                                internalBuildParticipant.setBuildContext(null);
                                this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                                throw throwable;
                            }
                            log.debug("Finished executing build participant {} for plugin execution {} in {} ms", new Object[]{internalBuildParticipant.getClass().getName(), mojoExecutionKey.toString(), System.currentTimeMillis() - executionStartTime});
                            internalBuildParticipant.setMavenProjectFacade(null);
                            internalBuildParticipant.setGetDeltaCallback(null);
                            internalBuildParticipant.setSession(null);
                            internalBuildParticipant.setBuildContext(null);
                            this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                        }
                    }
                }
                catch (Exception e) {
                    buildErrors.put(e, null);
                    ThreadBuildContext.setThreadBuildContext(null);
                    break block23;
                }
            }
            catch (Throwable throwable) {
                ThreadBuildContext.setThreadBuildContext(null);
                throw throwable;
            }
            ThreadBuildContext.setThreadBuildContext(null);
        }
        this.refreshResources(project, buildContext, monitor);
        MavenExecutionResult result = session.getResult();
        this.processBuildResults(mavenProject, result, buildContext, buildErrors);
        log.debug("Built project {} in {} ms", (Object)project.getName(), (Object)(System.currentTimeMillis() - start));
        if (dependencies.isEmpty()) {
            return null;
        }
        return dependencies.toArray(new IProject[dependencies.size()]);
    }

    private void refreshResources(IProject project, AbstractEclipseBuildContext buildContext, IProgressMonitor monitor) throws CoreException {
        for (File file : buildContext.getFiles()) {
            IPath path = MavenBuilder.getProjectRelativePath(project, file);
            if (path == null) {
                log.debug("Could not get relative path for file: ", (Object)file.getAbsoluteFile());
                continue;
            }
            if (!file.exists()) {
                IResource resource = project.findMember(path);
                if (resource == null) continue;
                resource.refreshLocal(2, monitor);
                continue;
            }
            if (file.isDirectory()) {
                IFolder ifolder = project.getFolder(path);
                ifolder.refreshLocal(2, monitor);
                continue;
            }
            IFile ifile = project.getFile(path);
            ifile.refreshLocal(0, monitor);
        }
    }

    private void processMavenSessionErrors(MavenSession session, MojoExecutionKey mojoExecutionKey, Map<Throwable, MojoExecutionKey> buildErrors) {
        MavenExecutionResult result = session.getResult();
        if (result.hasExceptions()) {
            for (Throwable e : result.getExceptions()) {
                buildErrors.put(e, mojoExecutionKey);
            }
            result.getExceptions().clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processBuildResults(MavenProject mavenProject, MavenExecutionResult result, AbstractEclipseBuildContext buildContext, Map<Throwable, MojoExecutionKey> buildErrors) {
        String buildParticipantId;
        IMavenMarkerManager markerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
        for (Map.Entry<String, List<File>> entry : buildContext.getRemoveMessages().entrySet()) {
            buildParticipantId = entry.getKey();
            for (File file : entry.getValue()) {
                this.deleteBuildParticipantMarkers(markerManager, file, buildParticipantId);
            }
        }
        for (Map.Entry<String, List<Object>> entry : buildContext.getMessages().entrySet()) {
            buildParticipantId = entry.getKey();
            for (AbstractEclipseBuildContext.Message message : entry.getValue()) {
                this.addBuildParticipantMarker(markerManager, message, buildParticipantId);
                if (message.cause == null || !buildErrors.containsKey(message.cause)) continue;
                buildErrors.remove(message.cause);
            }
        }
        for (Throwable throwable : buildErrors.keySet()) {
            void var9_20;
            MojoExecutionKey mojoExecutionKey = buildErrors.get(throwable);
            if (mojoExecutionKey != null) {
                SourceLocation sourceLocation = SourceLocationHelper.findLocation(mavenProject, mojoExecutionKey);
            } else {
                SourceLocation sourceLocation = new SourceLocation(1, 0, 0);
            }
            BuildProblemInfo problem = new BuildProblemInfo(throwable, mojoExecutionKey, (SourceLocation)var9_20);
            IProject project = this.getProject();
            markerManager.addErrorMarker((IResource)project.getFile("pom.xml"), "org.eclipse.m2e.core.maven2Problem.build", problem);
        }
        if (result.hasExceptions()) {
            IProject iProject = this.getProject();
            markerManager.addMarkers((IResource)iProject.getFile("pom.xml"), "org.eclipse.m2e.core.maven2Problem.build", result);
        }
    }

    private void deleteBuildParticipantMarkers(IMavenMarkerManager markerManager, File file, String buildParticipantId) {
        IProject project = this.getProject();
        IPath path = MavenBuilder.getProjectRelativePath(this.getProject(), file);
        IResource resource = null;
        if (path != null) {
            resource = project.findMember(path);
        }
        if (resource == null) {
            resource = project.getFile("pom.xml");
        }
        try {
            markerManager.deleteMarkers(resource, "org.eclipse.m2e.core.maven2Problem.build.participant", BUILD_PARTICIPANT_ID_ATTR_NAME, buildParticipantId);
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void addBuildParticipantMarker(IMavenMarkerManager markerManager, AbstractEclipseBuildContext.Message buildMessage, String buildParticipantId) {
        IProject project = this.getProject();
        IPath path = MavenBuilder.getProjectRelativePath(this.getProject(), buildMessage.file);
        IResource resource = null;
        if (path != null) {
            resource = project.findMember(path);
        }
        if (resource == null) {
            resource = project.getFile("pom.xml");
        }
        int at = buildParticipantId.lastIndexOf(45);
        String pluginExecutionKey = buildParticipantId.substring(0, at);
        String message = String.valueOf(buildMessage.message) + " (" + pluginExecutionKey + ')';
        IMarker marker = markerManager.addMarker(resource, "org.eclipse.m2e.core.maven2Problem.build.participant", message, buildMessage.line, buildMessage.severity);
        try {
            marker.setAttribute(BUILD_PARTICIPANT_ID_ATTR_NAME, (Object)buildParticipantId);
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void addErrorMarker(Exception e) {
        String msg = e.getMessage();
        String rootCause = M2EUtils.getRootCauseMessage(e);
        if (!e.equals(msg)) {
            msg = String.valueOf(msg) + ": " + rootCause;
        }
        IMavenMarkerManager markerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
        markerManager.addMarker((IResource)this.getProject(), "org.eclipse.m2e.core.maven2Problem.build", msg, 1, 2);
    }

    public static IPath getProjectRelativePath(IProject project, File file) {
        if (project == null || file == null) {
            return null;
        }
        IPath projectPath = project.getLocation();
        if (projectPath == null) {
            return null;
        }
        Path filePath = new Path(file.getAbsolutePath());
        if (!projectPath.isPrefixOf((IPath)filePath)) {
            return null;
        }
        return filePath.removeFirstSegments(projectPath.segmentCount());
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        EclipseBuildContext buildContext;
        LinkedHashMap<Throwable, MojoExecutionKey> buildErrors;
        MavenSession session;
        MavenProject mavenProject;
        IProject project;
        block18: {
            IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
            IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
            project = this.getProject();
            IMavenMarkerManager markerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
            markerManager.deleteMarkers((IResource)project, "org.eclipse.m2e.core.maven2Problem.build");
            if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                return;
            }
            IFile pomResource = project.getFile("pom.xml");
            if (pomResource == null) {
                return;
            }
            IMavenProjectFacade projectFacade = projectManager.create(this.getProject(), monitor);
            if (projectFacade == null) {
                return;
            }
            IMaven maven = MavenPlugin.getMaven();
            project.setSessionProperty(BUILD_CONTEXT_KEY, null);
            MavenExecutionRequest request = projectManager.createExecutionRequest(pomResource, projectFacade.getResolverConfiguration(), monitor);
            mavenProject = null;
            try {
                mavenProject = projectFacade.getMavenProject(monitor);
            }
            catch (CoreException ce) {
                this.addErrorMarker((Exception)((Object)ce));
                return;
            }
            session = maven.createSession(request, projectFacade.getMavenProject(monitor));
            ILifecycleMapping lifecycleMapping = configurationManager.getLifecycleMapping(projectFacade);
            if (lifecycleMapping == null) {
                return;
            }
            buildErrors = new LinkedHashMap<Throwable, MojoExecutionKey>();
            HashMap<String, Object> contextState = new HashMap<String, Object>();
            buildContext = new EclipseBuildContext(project, contextState);
            ThreadBuildContext.setThreadBuildContext((BuildContext)buildContext);
            try {
                try {
                    Map<MojoExecutionKey, List<AbstractBuildParticipant>> buildParticipantsByMojoExecutionKey = lifecycleMapping.getBuildParticipants(projectFacade, monitor);
                    for (Map.Entry<MojoExecutionKey, List<AbstractBuildParticipant>> entry : buildParticipantsByMojoExecutionKey.entrySet()) {
                        MojoExecutionKey mojoExecutionKey = entry.getKey();
                        for (InternalBuildParticipant internalBuildParticipant : entry.getValue()) {
                            String stringMojoExecutionKey = mojoExecutionKey.getKeyString();
                            buildContext.setCurrentBuildParticipantId(String.valueOf(stringMojoExecutionKey) + "-" + internalBuildParticipant.getClass().getName());
                            internalBuildParticipant.setMavenProjectFacade(projectFacade);
                            internalBuildParticipant.setGetDeltaCallback(this.getDeltaCallback);
                            internalBuildParticipant.setSession(session);
                            internalBuildParticipant.setBuildContext(buildContext);
                            try {
                                try {
                                    internalBuildParticipant.clean(monitor);
                                }
                                catch (Exception e) {
                                    log.debug("Exception in build participant", (Throwable)e);
                                    buildErrors.put(e, mojoExecutionKey);
                                    internalBuildParticipant.setMavenProjectFacade(null);
                                    internalBuildParticipant.setGetDeltaCallback(null);
                                    internalBuildParticipant.setSession(null);
                                    internalBuildParticipant.setBuildContext(null);
                                    this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                internalBuildParticipant.setMavenProjectFacade(null);
                                internalBuildParticipant.setGetDeltaCallback(null);
                                internalBuildParticipant.setSession(null);
                                internalBuildParticipant.setBuildContext(null);
                                this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                                throw throwable;
                            }
                            internalBuildParticipant.setMavenProjectFacade(null);
                            internalBuildParticipant.setGetDeltaCallback(null);
                            internalBuildParticipant.setSession(null);
                            internalBuildParticipant.setBuildContext(null);
                            this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                        }
                    }
                }
                catch (Exception e) {
                    buildErrors.put(e, null);
                    ThreadBuildContext.setThreadBuildContext(null);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                ThreadBuildContext.setThreadBuildContext(null);
                throw throwable;
            }
            ThreadBuildContext.setThreadBuildContext(null);
        }
        this.refreshResources(project, buildContext, monitor);
        MavenExecutionResult result = session.getResult();
        this.processBuildResults(mavenProject, result, buildContext, buildErrors);
    }

    static interface GetDeltaCallback {
        public IResourceDelta getDelta(IProject var1);
    }
}

