/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.m2e.core.internal.lifecyclemapping.DuplicateMappingException;
import org.eclipse.m2e.core.internal.lifecyclemapping.MappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleMappingMetadataSource
implements MappingMetadataSource {
    private final List<LifecycleMappingMetadata> lifecycleMappings = new ArrayList<LifecycleMappingMetadata>();
    private final List<PluginExecutionMetadata> pluginExecutions = new ArrayList<PluginExecutionMetadata>();

    public SimpleMappingMetadataSource(LifecycleMappingMetadataSource source) {
        this.lifecycleMappings.addAll(source.getLifecycleMappings());
        this.pluginExecutions.addAll(source.getPluginExecutions());
    }

    public SimpleMappingMetadataSource(List<LifecycleMappingMetadataSource> sources) {
        for (LifecycleMappingMetadataSource source : sources) {
            this.lifecycleMappings.addAll(source.getLifecycleMappings());
            this.pluginExecutions.addAll(source.getPluginExecutions());
        }
    }

    public SimpleMappingMetadataSource(LifecycleMappingMetadata lifecycleMapping) {
        this.pluginExecutions.addAll(lifecycleMapping.getPluginExecutions());
    }

    @Override
    public LifecycleMappingMetadata getLifecycleMappingMetadata(String packagingType) throws DuplicateMappingException {
        if (packagingType == null) {
            return null;
        }
        LifecycleMappingMetadata mapping = null;
        for (LifecycleMappingMetadata _mapping : this.lifecycleMappings) {
            if (!packagingType.equals(_mapping.getPackagingType())) continue;
            if (mapping != null) {
                throw new DuplicateMappingException();
            }
            mapping = _mapping;
        }
        return mapping;
    }

    @Override
    public List<PluginExecutionMetadata> getPluginExecutionMetadata(MojoExecutionKey execution) {
        ArrayList<PluginExecutionMetadata> mappings = new ArrayList<PluginExecutionMetadata>();
        if (execution != null) {
            for (PluginExecutionMetadata mapping : this.pluginExecutions) {
                if (!mapping.getFilter().match(execution)) continue;
                mappings.add(mapping);
            }
        }
        return mappings;
    }
}

