/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.jobs.IBackgroundProcessingQueue;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectRegistryRefreshJob
extends Job
implements IResourceChangeListener,
IEclipsePreferences.IPreferenceChangeListener,
IBackgroundProcessingQueue {
    private static final Logger log = LoggerFactory.getLogger(ProjectRegistryRefreshJob.class);
    private static final long SCHEDULE_DELAY = 1000L;
    private static final int DELTA_FLAGS = 276736;
    private final List<MavenUpdateRequest> queue = new ArrayList<MavenUpdateRequest>();
    private final ProjectRegistryManager manager;
    private final IMavenConfiguration mavenConfiguration;

    public ProjectRegistryRefreshJob(ProjectRegistryManager manager, IMavenConfiguration mavenConfiguration) {
        super(Messages.ProjectRegistryRefreshJob_title);
        this.manager = manager;
        this.mavenConfiguration = mavenConfiguration;
    }

    public void refresh(MavenUpdateRequest updateRequest) {
        this.queue(updateRequest);
        this.schedule(1000L);
    }

    /*
     * Exception decompiling
     */
    public IStatus run(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        boolean offline = this.mavenConfiguration.isOffline();
        boolean forceDependencyUpdate = false;
        int type = event.getType();
        if (2 == type || 4 == type) {
            this.queue(new MavenUpdateRequest((IProject)event.getResource(), offline, forceDependencyUpdate));
        } else {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            boolean autobuilding = workspace != null && workspace.isAutoBuilding();
            IResourceDelta delta = event.getDelta();
            IResourceDelta[] projectDeltas = delta.getAffectedChildren();
            LinkedHashSet<IProject> refreshProjects = new LinkedHashSet<IProject>();
            int i = 0;
            while (i < projectDeltas.length) {
                IProject project;
                IMavenProjectFacade facade;
                IResourceDelta projectDelta = projectDeltas[i];
                if ((projectDelta.getFlags() & 0x4000) != 0) {
                    this.queue(new MavenUpdateRequest((IProject)projectDelta.getResource(), offline, forceDependencyUpdate));
                } else if (!autobuilding && this.projectChanged(projectDelta) && ((facade = this.manager.getProject(project = (IProject)projectDelta.getResource())) == null || facade.isStale())) {
                    refreshProjects.add(project);
                }
                ++i;
            }
            if (!refreshProjects.isEmpty()) {
                IProject[] projects = refreshProjects.toArray(new IProject[refreshProjects.size()]);
                MavenUpdateRequest updateRequest = new MavenUpdateRequest(projects, offline, forceDependencyUpdate);
                this.queue(updateRequest);
            }
        }
        List<MavenUpdateRequest> list = this.queue;
        synchronized (list) {
            if (!this.queue.isEmpty()) {
                this.schedule(1000L);
            }
        }
    }

    private boolean projectChanged(IResourceDelta projectDelta) {
        for (IPath iPath : ProjectRegistryManager.METADATA_PATH) {
            IResourceDelta delta = projectDelta.findMember(iPath);
            if (delta == null || !this.isInterestingDelta(delta)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queue(MavenUpdateRequest updateRequest) {
        List<MavenUpdateRequest> list = this.queue;
        synchronized (list) {
            this.queue.add(updateRequest);
            log.debug("Queued refresh request: {}", (Object)updateRequest.toString());
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        boolean offline = this.mavenConfiguration.isOffline();
        boolean updateSnapshots = false;
        if (event.getSource() instanceof IProject) {
            this.queue(new MavenUpdateRequest((IProject)event.getSource(), offline, updateSnapshots));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        List<MavenUpdateRequest> list = this.queue;
        synchronized (list) {
            return this.queue.isEmpty();
        }
    }

    protected boolean isInterestingDelta(IResourceDelta delta) {
        return delta.getKind() == 2 || delta.getKind() == 1 || delta.getKind() == 4 && (delta.getFlags() & 0x43900) != 0;
    }
}

