/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Locale;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.xml.common.ElementWriter;
import org.openstreetmap.osmosis.xml.v0_6.impl.TagWriter;

public class NodeWriter
extends ElementWriter {
    private TagWriter tagWriter;
    private NumberFormat numberFormat;

    public NodeWriter(String elementName, int indentLevel) {
        super(elementName, indentLevel);
        this.tagWriter = new TagWriter("tag", indentLevel + 1);
        this.numberFormat = new DecimalFormat("0.#######;-0.#######", new DecimalFormatSymbols(Locale.US));
    }

    public void process(Node node) {
        OsmUser user = node.getUser();
        this.beginOpenElement();
        this.addAttribute("id", Long.toString(node.getId()));
        this.addAttribute("version", Integer.toString(node.getVersion()));
        this.addAttribute("timestamp", node.getFormattedTimestamp(this.getTimestampFormat()));
        if (!user.equals((Object)OsmUser.NONE)) {
            this.addAttribute("uid", Integer.toString(user.getId()));
            this.addAttribute("user", user.getName());
        }
        if (node.getChangesetId() != 0L) {
            this.addAttribute("changeset", Long.toString(node.getChangesetId()));
        }
        this.addAttribute("lat", this.numberFormat.format(node.getLatitude()));
        this.addAttribute("lon", this.numberFormat.format(node.getLongitude()));
        Collection tags = node.getTags();
        if (tags.size() > 0) {
            this.endOpenElement(false);
            for (Tag tag : tags) {
                this.tagWriter.process(tag);
            }
            this.closeElement();
        } else {
            this.endOpenElement(true);
        }
    }

    @Override
    public void setWriter(Writer writer) {
        super.setWriter(writer);
        this.tagWriter.setWriter(writer);
    }
}

