/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.xml.common.BaseElementProcessor;
import org.openstreetmap.osmosis.xml.common.ElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.BoundElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.NodeElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.RelationElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.SourceElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.WayElementProcessor;
import org.xml.sax.Attributes;

public class OsmElementProcessor
extends SourceElementProcessor {
    private static final Logger LOG = Logger.getLogger(OsmElementProcessor.class.getName());
    private static final String ELEMENT_NAME_BOUND = "bound";
    private static final String ELEMENT_NAME_NODE = "node";
    private static final String ELEMENT_NAME_WAY = "way";
    private static final String ELEMENT_NAME_RELATION = "relation";
    private static final String ATTRIBUTE_NAME_VERSION = "version";
    private BoundElementProcessor boundElementProcessor;
    private NodeElementProcessor nodeElementProcessor;
    private WayElementProcessor wayElementProcessor;
    private RelationElementProcessor relationElementProcessor;
    private boolean foundBound = false;
    private boolean foundEntities = false;
    private boolean validateVersion;

    public OsmElementProcessor(BaseElementProcessor parentProcessor, Sink sink, boolean enableDateParsing, boolean validateVersion) {
        super(parentProcessor, sink, enableDateParsing);
        this.validateVersion = validateVersion;
        this.boundElementProcessor = new BoundElementProcessor(this, this.getSink(), enableDateParsing);
        this.nodeElementProcessor = new NodeElementProcessor(this, this.getSink(), enableDateParsing);
        this.wayElementProcessor = new WayElementProcessor(this, this.getSink(), enableDateParsing);
        this.relationElementProcessor = new RelationElementProcessor(this, this.getSink(), enableDateParsing);
    }

    @Override
    public void begin(Attributes attributes) {
        String fileVersion;
        if (this.validateVersion && !"0.6".equals(fileVersion = attributes.getValue(ATTRIBUTE_NAME_VERSION))) {
            LOG.warning("Expected version 0.6 but received " + fileVersion + ".");
        }
    }

    @Override
    public ElementProcessor getChild(String uri, String localName, String qName) {
        if (ELEMENT_NAME_BOUND.equals(qName)) {
            if (this.foundEntities) {
                throw new OsmosisRuntimeException("Bound element must come before any entities.");
            }
            if (this.foundBound) {
                throw new OsmosisRuntimeException("Only one bound element allowed.");
            }
            this.foundBound = true;
            return this.boundElementProcessor;
        }
        if (ELEMENT_NAME_NODE.equals(qName)) {
            this.foundEntities = true;
            return this.nodeElementProcessor;
        }
        if (ELEMENT_NAME_WAY.equals(qName)) {
            this.foundEntities = true;
            return this.wayElementProcessor;
        }
        if (ELEMENT_NAME_RELATION.equals(qName)) {
            this.foundEntities = true;
            return this.relationElementProcessor;
        }
        return super.getChild(uri, localName, qName);
    }

    @Override
    public void end() {
    }
}

