/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.distance.DistanceOp;

public class HausdorffDistance {
    private LineString line1;
    private LineString line2;
    private Coordinate c1 = null;
    private Coordinate c2 = null;
    private double distance = -1.0;

    public HausdorffDistance(LineString line1, LineString line2) {
        this.line1 = line1;
        this.line2 = line2;
    }

    public double getDistance() {
        if (this.distance == -1.0) {
            this.update();
        }
        return this.distance;
    }

    public Coordinate[] getCoordinates() {
        if (this.c1 == null || this.c2 == null) {
            this.update();
        }
        return new Coordinate[]{this.c1, this.c2};
    }

    public void update() {
        double d2;
        Object[] hd1 = HausdorffDistance.compute_(this.line1, this.line2);
        Object[] hd2 = HausdorffDistance.compute_(this.line2, this.line1);
        double d1 = (Double)hd1[0];
        if (d1 > (d2 = ((Double)hd2[0]).doubleValue())) {
            this.distance = d1;
            this.c1 = (Coordinate)hd1[1];
            this.c2 = (Coordinate)hd1[2];
        } else {
            this.distance = d2;
            this.c1 = (Coordinate)hd2[2];
            this.c2 = (Coordinate)hd2[1];
        }
    }

    private static Object[] compute_(LineString lineA, LineString lineB) {
        Coordinate[] csA = lineA.getCoordinates();
        GeometryFactory gf = new GeometryFactory();
        double distMax = -1.0;
        Coordinate cAMax = null;
        Coordinate cBMax = null;
        for (int i = 0; i < csA.length; ++i) {
            Coordinate cA = csA[i];
            DistanceOp distOp = new DistanceOp((Geometry)gf.createPoint(cA), (Geometry)lineB);
            double dist = distOp.distance();
            if (!(dist > distMax)) continue;
            distMax = dist;
            cAMax = cA;
            cBMax = distOp.nearestPoints()[1];
        }
        return new Object[]{new Double(distMax), cAMax, cBMax};
    }
}

