/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin.pilot;

import com.bbn.openmap.MapHandler;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.plugin.pilot.Pilot;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.tools.j3d.ControlledManager;
import com.bbn.openmap.tools.j3d.NavBehaviorProvider;
import com.bbn.openmap.tools.j3d.OMKeyBehavior;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import javax.media.j3d.Background;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.vecmath.Vector3d;

public class PilotPath
extends Pilot
implements NavBehaviorProvider {
    double[] pathPoints = null;
    OMPoly poly = null;
    int pathIndex = 0;
    float currentSegDist = 0.0f;
    float nextSegOffset = 0.0f;
    float rate = Length.METER.toRadians(10000.0f);
    protected boolean DEBUG = false;
    protected Transform3D translateTransform = new Transform3D();
    protected Projection viewProjection;
    protected TransformGroup cameraTransformGroup;
    protected float scaleFactor = 1.0f;
    protected double lastX;
    protected double lastY;
    protected double lastAzimuth = 0.0;
    OMKeyBehavior platformBehavior;
    protected MapHandler mapHandler;
    public static final String Launch3DCmd = "Launch3D";

    public PilotPath(OMPoly path, int radius, boolean isOval) {
        super(0.0, 0.0, radius, isOval);
        this.setPoly(path);
        this.DEBUG = Debug.debugging((String)"pilot");
        this.setHeight(10.3f);
    }

    public void move(float factor) {
        if (!this.stationary) {
            this.moveAlong();
        }
    }

    public double[] getSegmentCoordinates(int currentPathIndex) {
        double[] latlons = new double[4];
        if (this.pathIndex > this.pathPoints.length - 2 || this.pathIndex < 0) {
            this.pathIndex = 0;
        }
        if (this.pathPoints != null && this.pathPoints.length >= 4) {
            int la1 = this.pathIndex;
            int lo1 = this.pathIndex + 1;
            int la2 = this.pathIndex + 2;
            int lo2 = this.pathIndex + 3;
            if (lo2 >= this.pathPoints.length) {
                if (this.poly.isPolygon()) {
                    if (this.DEBUG) {
                        Debug.output((String)"PilotPath.moveAlong(): index too big, wrapping... ");
                    }
                    la2 = 0;
                    lo2 = 1;
                } else {
                    this.pathIndex = 0;
                    if (this.DEBUG) {
                        Debug.output((String)"PilotPath.moveAlong(): index too big, no wrapping, starting over... ");
                    }
                    return this.getSegmentCoordinates(this.pathIndex);
                }
            }
            latlons[0] = this.pathPoints[la1];
            latlons[1] = this.pathPoints[lo1];
            latlons[2] = this.pathPoints[la2];
            latlons[3] = this.pathPoints[lo2];
        }
        return latlons;
    }

    public void moveAlong() {
        if (this.DEBUG) {
            Debug.output((String)("PilotPath.moveAlong(): segment " + this.pathIndex / 2 + " of " + this.pathPoints.length / 2));
        }
        double[] latlons = this.getSegmentCoordinates(this.pathIndex);
        double segLength = GreatCircle.sphericalDistance((double)latlons[0], (double)latlons[1], (double)latlons[2], (double)latlons[3]);
        if (this.DEBUG) {
            Debug.output((String)("PilotPath.moveAlong(): segment Length " + segLength + ", and already have " + this.currentSegDist + " of it."));
        }
        float needToTravel = this.rate;
        int originalPathIndex = this.pathIndex;
        int loopingTimes = 0;
        while ((double)needToTravel >= segLength - (double)this.currentSegDist) {
            needToTravel = (float)((double)needToTravel - (segLength - (double)this.currentSegDist));
            this.currentSegDist = 0.0f;
            this.pathIndex += 2;
            if (this.DEBUG) {
                Debug.output((String)("PilotPath to next segment(" + this.pathIndex / 2 + "), need to travel " + needToTravel));
            }
            latlons = this.getSegmentCoordinates(this.pathIndex);
            if (this.pathIndex == originalPathIndex && ++loopingTimes > 1) {
                if (this.DEBUG) {
                    Debug.output((String)"PilotPath looping on itself, setting to stationary");
                }
                this.setStationary(true);
                return;
            }
            segLength = GreatCircle.sphericalDistance((double)latlons[0], (double)latlons[1], (double)latlons[2], (double)latlons[3]);
        }
        if (this.DEBUG) {
            Debug.output((String)("Moving PilotPath within current(" + this.pathIndex / 2 + ") segment, segLength: " + segLength + ", ntt: " + needToTravel));
        }
        double azimuth = GreatCircle.sphericalAzimuth((double)latlons[0], (double)latlons[1], (double)latlons[2], (double)latlons[3]);
        LatLonPoint newPoint = GreatCircle.sphericalBetween((double)latlons[0], (double)latlons[1], (double)(this.currentSegDist + needToTravel), (double)azimuth);
        this.setLat((float)newPoint.getY());
        this.setLon((float)newPoint.getX());
        this.currentSegDist = (float)GreatCircle.sphericalDistance((double)latlons[0], (double)latlons[1], (double)Math.toRadians(newPoint.getY()), (double)Math.toRadians(newPoint.getX()));
        if (this.DEBUG) {
            Debug.output((String)("moveAlong: azimuth = " + azimuth));
        }
        if (this.viewProjection == null) {
            return;
        }
        Point2D newLoc = this.viewProjection.forward((Point2D)newPoint);
        if (this.DEBUG) {
            Debug.output((String)(newLoc.toString() + ", compared with lastX, lastY: " + this.lastX + ", " + this.lastY + ", scaleFactor= " + this.scaleFactor));
        }
        double centerXOffset = newLoc.getX() * (double)this.scaleFactor;
        double centerYOffset = newLoc.getY() * (double)this.scaleFactor;
        Vector3d translate = new Vector3d();
        translate.set(centerXOffset - this.lastX, 0.0, centerYOffset - this.lastY);
        this.lastX = centerXOffset;
        this.lastY = centerYOffset;
        if (this.DEBUG) {
            Debug.output((String)("PP moving: " + translate));
        }
        if (this.platformBehavior != null) {
            this.platformBehavior.doMove(translate);
            if (this.lastAzimuth != azimuth) {
                this.platformBehavior.doLookY(this.lastAzimuth - azimuth);
                this.lastAzimuth = azimuth;
            }
        }
    }

    public boolean generate(Projection p) {
        this.viewProjection = p;
        boolean ret = super.generate(p);
        if (this.poly != null) {
            this.poly.generate(p);
        }
        return ret;
    }

    public void render(Graphics g) {
        if (this.poly != null) {
            this.poly.render(g);
        }
        super.render(g);
    }

    public void setPoly(OMPoly p) {
        this.poly = p;
        if (this.poly.getRenderType() == 1) {
            this.pathPoints = this.poly.getLatLonArray();
            this.setLat(ProjMath.radToDeg((double)this.pathPoints[0]));
            this.setLon(ProjMath.radToDeg((double)this.pathPoints[1]));
            this.setStationary(false);
        } else {
            this.setStationary(true);
        }
    }

    public OMPoly getPoly() {
        return this.poly;
    }

    public Behavior setViewingPlatformBehavior(TransformGroup ctg, Projection projection, float scaleFactor) {
        if (this.DEBUG) {
            Debug.output((String)"PilotPath setting viewing platform behavior");
        }
        this.cameraTransformGroup = ctg;
        this.platformBehavior = new OMKeyBehavior(this.cameraTransformGroup, this.viewProjection, this.locateWorld(projection, scaleFactor));
        return this.platformBehavior;
    }

    public Vector3d locateWorld(Projection projection, float scaleFactor) {
        this.viewProjection = projection;
        this.translateTransform = new Transform3D();
        this.scaleFactor = scaleFactor;
        this.cameraTransformGroup.getTransform(this.translateTransform);
        if (this.DEBUG) {
            Debug.output((String)("PilotPath setting camera location, scaleFactor = " + this.scaleFactor));
        }
        Vector3d translate = new Vector3d();
        Point2D pilotPoint = projection.forward(this.getLat(), this.getLon());
        if (projection != null) {
            double centerXOffset = pilotPoint.getX() * (double)scaleFactor;
            double centerYOffset = pilotPoint.getY() * (double)scaleFactor;
            if (this.DEBUG) {
                Debug.output((String)("OM3DViewer with projection " + projection + ", setting center of scene to " + centerXOffset + ", " + centerYOffset));
            }
            translate.set(centerXOffset, (double)this.height, centerYOffset);
            this.lastX = centerXOffset;
            this.lastY = centerYOffset;
        } else {
            translate.set(0.0, (double)this.height, 0.0);
        }
        return translate;
    }

    public void setMapHandler(MapHandler mh) {
        this.mapHandler = mh;
    }

    public void launch3D() {
        JFrame viewer = ControlledManager.getFrame("OpenMap 3D", 500, 500, this.mapHandler, this, new Background(0.3f, 0.3f, 0.3f), 3);
        viewer.setVisible(true);
    }

    public Component getGUI() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        if (this.movementButton == null) {
            this.movementButton = new JCheckBox("Stationary", this.getStationary());
            this.movementButton.addActionListener(this);
            this.movementButton.setActionCommand("MoveCommand");
        }
        panel.add(this.movementButton);
        JPanel heightPanel = new JPanel(new GridLayout(0, 3));
        heightPanel.add(new JLabel("Object height: "));
        if (this.heightField == null) {
            this.heightField = new JTextField(Float.toString(this.height), 10);
            this.heightField.setHorizontalAlignment(4);
            this.heightField.addActionListener(this);
            this.heightField.addFocusListener(this);
        }
        heightPanel.add(this.heightField);
        heightPanel.add(new JLabel(" "));
        panel.add(heightPanel);
        JButton launch3DButton = new JButton("Launch 3D");
        launch3DButton.setActionCommand(Launch3DCmd);
        launch3DButton.addActionListener(this);
        panel.add(launch3DButton);
        return panel;
    }

    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
        String cmd = ae.getActionCommand();
        if (cmd == Launch3DCmd) {
            this.launch3D();
        }
    }
}

