/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.j3d;

import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGeometryList;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMGrid;
import com.bbn.openmap.omGraphics.grid.GridData;
import com.bbn.openmap.omGraphics.grid.OMGridGenerator;
import com.bbn.openmap.omGraphics.grid.SimpleColorGenerator;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import com.sun.j3d.utils.geometry.Triangulator;
import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Color4b;
import javax.vecmath.Point3d;

public class OMGraphicUtil {
    public static final int DEFAULT_NPOINTS_BUFFER_SIZE = 100;
    public static final Iterator NULL_ITERATOR = new HashSet().iterator();

    public static Iterator createShape3D(OMGraphic graphic) {
        return OMGraphicUtil.createShape3D(graphic, 0.0);
    }

    public static Iterator createShape3D(OMGraphic graphic, double baselineHeight) {
        GeneralPath shape;
        Debug.message((String)"3detail", (String)"OMGraphicUtil.createShape3D()");
        boolean DEBUG_SHAPE = Debug.debugging((String)"3dshape");
        if (graphic == null) {
            return NULL_ITERATOR;
        }
        if (graphic instanceof OMGraphicList && !(graphic instanceof OMGeometryList)) {
            HashSet set = new HashSet();
            for (OMGraphic subgraphic : (OMGraphicList)graphic) {
                Debug.message((String)"3detail", (String)"OMGraphicUtil.createShape3D():  recursivly adding list...");
                Iterator iterator = OMGraphicUtil.createShape3D(subgraphic, baselineHeight);
                while (iterator.hasNext()) {
                    set.add(iterator.next());
                }
            }
            return set.iterator();
        }
        if (DEBUG_SHAPE) {
            Debug.output((String)"OMGraphicUtil.createShape3D():  adding shape...");
        }
        if ((shape = graphic.getShape()) != null) {
            if (graphic.shouldRenderFill()) {
                return OMGraphicUtil.createShape3D(shape, baselineHeight, graphic.getFillColor(), true);
            }
            if (graphic.shouldRenderEdge()) {
                return OMGraphicUtil.createShape3D(shape, baselineHeight, graphic.getDisplayColor(), false);
            }
            if (DEBUG_SHAPE) {
                Debug.output((String)"OMGraphicUtil.createShape3D(): can't render graphic");
            }
        } else if (DEBUG_SHAPE) {
            Debug.output((String)"OMGraphicUtil.createShape3D(): shape from graphic is null");
        }
        return NULL_ITERATOR;
    }

    public static Iterator createShape3D(OMGrid grid, double baselineHeight, Projection projection) {
        boolean polyline;
        if (grid.getRenderType() != 1) {
            Debug.error((String)"OMGraphicUtil.createShape3D:  can't handle non-LATLON grids yet");
            return NULL_ITERATOR;
        }
        boolean DEBUG = false;
        if (Debug.debugging((String)"3dgrid")) {
            DEBUG = true;
        }
        Color fColor = grid.getFillColor();
        Color lColor = grid.getLineColor();
        boolean bl = polyline = fColor == OMColor.clear;
        if (DEBUG) {
            Debug.output((String)("Polyline = " + polyline));
        }
        Color3f fillcolor = new Color3f(fColor);
        Color3f linecolor = new Color3f(lColor);
        int numRows = grid.getRows();
        int numCols = grid.getColumns();
        int stripCount = numRows - 1;
        int numberVerticesPerStrip = numCols * 2;
        int[] stripCounts = new int[stripCount];
        for (int i = 0; i < stripCount; ++i) {
            stripCounts[i] = numberVerticesPerStrip;
        }
        LatLonPoint.Double anchorLL = new LatLonPoint.Double(grid.getLatitude(), grid.getLongitude());
        double vRes = grid.getVerticalResolution();
        double hRes = grid.getHorizontalResolution();
        TriangleStripArray gridStrip = new TriangleStripArray(stripCount * numberVerticesPerStrip, 7, stripCounts);
        Point p = new Point();
        int pointer = 0;
        GridData gridData = grid.getData();
        if (!(gridData instanceof GridData.Int)) {
            Debug.error((String)"OMGrid.interpValueAt only works for integer data.");
        }
        int[][] data = ((GridData.Int)gridData).getData();
        boolean major = gridData.getMajor();
        SimpleColorGenerator generator = null;
        OMGridGenerator tempGen = grid.getGenerator();
        if (tempGen instanceof SimpleColorGenerator) {
            generator = (SimpleColorGenerator)tempGen;
        }
        for (int j = 0; j < numRows - 1; ++j) {
            if (DEBUG) {
                Debug.output((String)("Creating strip " + j));
            }
            double lat1 = anchorLL.getY() + (double)j * vRes;
            double lat2 = anchorLL.getY() + ((double)j + 1.0) * vRes;
            for (int k = 0; k < numCols; ++k) {
                if (DEBUG) {
                    Debug.output((String)("   working row " + k));
                }
                double lon = anchorLL.getX() + (double)k * hRes;
                projection.forward(lat1, lon, (Point2D)p);
                int dataPoint = major ? data[k][j] : data[j][k];
                gridStrip.setCoordinate(pointer, new Point3d((double)((float)p.getX()), (double)dataPoint, (double)((float)p.getY())));
                if (DEBUG) {
                    Debug.output((String)("       1st coord " + p.getX() + ", " + dataPoint + ", " + p.getY()));
                }
                projection.forward(lat2, lon, (Point2D)p);
                dataPoint = major ? data[k][j + 1] : data[j + 1][k];
                gridStrip.setCoordinate(pointer + 1, new Point3d((double)((float)p.getX()), (double)dataPoint, (double)((float)p.getY())));
                if (DEBUG) {
                    Debug.output((String)("       2nd coord " + p.getX() + ", " + dataPoint + ", " + p.getY()));
                }
                Color3f color = generator == null ? (polyline ? linecolor : fillcolor) : new Color3f(new Color(generator.calibratePointValue(dataPoint)));
                gridStrip.setColor(pointer++, color);
                gridStrip.setColor(pointer++, color);
            }
        }
        Shape3D shape = new Shape3D((Geometry)gridStrip);
        Appearance appear = new Appearance();
        PolygonAttributes polyAttrib = new PolygonAttributes();
        if (polyline) {
            polyAttrib.setPolygonMode(1);
        }
        polyAttrib.setCullFace(0);
        appear.setPolygonAttributes(polyAttrib);
        shape.setAppearance(appear);
        HashSet<Shape3D> set = new HashSet<Shape3D>();
        set.add(shape);
        return set.iterator();
    }

    public static Iterator createShape3D(Shape shape, double baselineHeight, Color color, boolean filled) {
        int bufferSize = 100;
        double[] data = OMGraphicUtil.expandArrayD(bufferSize, null);
        int dataIndex = 0;
        int refreshCounter = bufferSize;
        int[] stripCount = new int[]{0};
        PathIterator pi2 = shape.getPathIterator(null);
        float flatness = 0.25f;
        FlatteningPathIterator pi = new FlatteningPathIterator(pi2, flatness);
        double[] coords = new double[6];
        double pntx = 0.0;
        double pnty = 0.0;
        double pntz = baselineHeight;
        HashSet<Shape3D> set = new HashSet<Shape3D>();
        Shape3D shape3D = null;
        Debug.message((String)"3detail", (String)"OMGraphicUtil.createShape3D(): figuring out coordinates");
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (dataIndex != 0) {
                        shape3D = OMGraphicUtil.createShape3D(data, dataIndex, stripCount, color, filled);
                        if (shape3D != null) {
                            set.add(shape3D);
                        }
                        data = OMGraphicUtil.expandArrayD(bufferSize, null);
                        dataIndex = 0;
                    }
                }
                case 1: {
                    pntx = coords[0];
                    pnty = coords[1];
                    if (Debug.debugging((String)"3detail")) {
                        Debug.output((String)("Shape coordinates: " + pntx + ", " + pnty));
                    }
                    if (dataIndex >= data.length) {
                        data = OMGraphicUtil.expandArrayD(bufferSize, data);
                        refreshCounter = bufferSize;
                    }
                    data[dataIndex++] = pntx;
                    data[dataIndex++] = pntz;
                    data[dataIndex++] = pnty;
                    stripCount[0] = stripCount[0] + 1;
                    refreshCounter -= 3;
                    break;
                }
                default: {
                    Debug.message((String)"3detail", (String)("Shape coordinates: " + coords[0] + ", " + coords[1] + " rounding out SEG_CLOSE"));
                }
            }
            pi.next();
        }
        if (dataIndex != 0 && (shape3D = OMGraphicUtil.createShape3D(data, dataIndex, stripCount, color, filled)) != null) {
            set.add(shape3D);
        }
        return set.iterator();
    }

    public static Shape3D createShape3D(double[] data, int realDataIndex, int[] stripCount, Color color, boolean filled) {
        try {
            double[] newData = new double[realDataIndex];
            System.arraycopy(data, 0, newData, 0, realDataIndex);
            if (filled) {
                return OMGraphicUtil.createFilled(newData, stripCount, color);
            }
            return OMGraphicUtil.createEdges(newData, color);
        }
        catch (IllegalArgumentException iae) {
            Debug.error((String)("OMGraphicUtil.createShape3D():  IllegalArgumentException caught: \n" + iae.toString()));
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < stripCount.length; ++i) {
                sb.append("{" + stripCount[i] + "}");
            }
            Debug.output((String)("Something funny happened on " + (filled ? "filled" : "edge") + " data[" + data.length + "], reflecting " + data.length / 3 + " nodes, with stripCount[" + stripCount.length + "] " + sb.toString()));
            return null;
        }
    }

    public static Shape3D createFilled(double[] data, int[] stripCount, Color color) throws IllegalArgumentException {
        Debug.message((String)"3detail", (String)("OMGraphicUtil: adding polygon, data length " + data.length + ", reflecting " + data.length / 3 + " nodes, with a strip count of " + stripCount));
        GeometryInfo gi = new GeometryInfo(5);
        gi.setCoordinates(data);
        gi.setStripCounts(stripCount);
        Triangulator tr = new Triangulator();
        Debug.message((String)"3detail", (String)"OMGraphicUtil: begin triangulation");
        tr.triangulate(gi);
        Debug.message((String)"3detail", (String)"OMGraphicUtil: end triangulation");
        gi.recomputeIndices();
        NormalGenerator ng = new NormalGenerator();
        ng.generateNormals(gi);
        gi.recomputeIndices();
        Stripifier st = new Stripifier();
        st.stripify(gi);
        gi.recomputeIndices();
        Shape3D shape3D = new Shape3D();
        shape3D.setAppearance(OMGraphicUtil.createMaterialAppearance(color));
        shape3D.setGeometry((Geometry)gi.getGeometryArray());
        return shape3D;
    }

    public static Shape3D createEdges(double[] data, Color color) throws IllegalArgumentException {
        int numPoints = data.length / 3;
        Debug.message((String)"3detail", (String)("OMGraphicUtil: adding polyline of " + numPoints + " points."));
        LineStripArray la = new LineStripArray(numPoints, 13, new int[]{numPoints});
        la.setCoordinates(0, data);
        Color4b[] colors = OMGraphicUtil.createColorArray(numPoints, color);
        la.setColors(0, colors);
        return new Shape3D((Geometry)la);
    }

    public static Appearance createMaterialAppearance(Color color) {
        Appearance materialAppear = new Appearance();
        PolygonAttributes polyAttrib = new PolygonAttributes();
        polyAttrib.setCullFace(0);
        materialAppear.setPolygonAttributes(polyAttrib);
        Material material = new Material();
        material.setAmbientColor(new Color3f(color));
        materialAppear.setMaterial(material);
        return materialAppear;
    }

    public static Appearance createWireFrameAppearance(Color color) {
        Appearance materialAppear = new Appearance();
        PolygonAttributes polyAttrib = new PolygonAttributes();
        polyAttrib.setPolygonMode(1);
        materialAppear.setPolygonAttributes(polyAttrib);
        ColoringAttributes redColoring = new ColoringAttributes();
        redColoring.setColor(1.0f, 0.0f, 0.0f);
        materialAppear.setColoringAttributes(redColoring);
        return materialAppear;
    }

    public static Color4b[] createColorArray(int size, Color color) {
        Color4b[] colors = new Color4b[size];
        for (int i = 0; i < size; ++i) {
            colors[i] = new Color4b(color);
        }
        return colors;
    }

    public static double[] expandArrayD(int bufferSize, double[] currentArray) {
        if (currentArray == null) {
            return new double[bufferSize * 3];
        }
        int length = currentArray.length;
        double[] ret = new double[length + bufferSize * 3];
        System.arraycopy(currentArray, 0, ret, 0, length);
        return ret;
    }

    public static float[] expandArrayF(int bufferSize, float[] currentArray) {
        if (currentArray == null) {
            return new float[bufferSize * 3];
        }
        int length = currentArray.length;
        float[] ret = new float[length + bufferSize * 3];
        System.arraycopy(currentArray, 0, ret, 0, length);
        return ret;
    }
}

