/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.UniqueCoordinateArrayFilter;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.util.Assert;
import com.vividsolutions.jts.geom.util.CGAlgorithms;
import com.vividsolutions.jts.operation.distance.RayCrossingCounter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Stack;
import java.util.TreeSet;

public class ConvexHull {
    private GeometryFactory geomFactory;
    private Coordinate[] inputPts;

    public ConvexHull(Geometry geometry) {
        this(ConvexHull.extractCoordinates(geometry), geometry.getFactory());
    }

    public ConvexHull(Coordinate[] pts, GeometryFactory geomFactory) {
        this.inputPts = pts;
        this.geomFactory = geomFactory;
    }

    private static Coordinate[] extractCoordinates(Geometry geom) {
        UniqueCoordinateArrayFilter filter = new UniqueCoordinateArrayFilter();
        geom.apply((CoordinateFilter)filter);
        return filter.getCoordinates();
    }

    public Geometry getConvexHull() {
        if (this.inputPts.length == 0) {
            return this.geomFactory.createGeometryCollection(null);
        }
        if (this.inputPts.length == 1) {
            return this.geomFactory.createPoint(this.inputPts[0]);
        }
        if (this.inputPts.length == 2) {
            return this.geomFactory.createLineString(this.inputPts);
        }
        Coordinate[] reducedPts = this.inputPts;
        if (this.inputPts.length > 50) {
            reducedPts = ConvexHull.reduce(this.inputPts);
        }
        Coordinate[] sortedPts = ConvexHull.preSort(reducedPts);
        Stack<Coordinate> cHS = ConvexHull.grahamScan(sortedPts);
        Coordinate[] cH = this.toCoordinateArray(cHS);
        return this.lineOrPolygon(cH);
    }

    protected Coordinate[] toCoordinateArray(Stack<Coordinate> stack) {
        Coordinate[] coordinates = new Coordinate[stack.size()];
        for (int i = 0; i < stack.size(); ++i) {
            coordinates[i] = (Coordinate)stack.get(i);
        }
        return coordinates;
    }

    private static Coordinate[] reduce(Coordinate[] pts) {
        int i;
        Coordinate[] polyPts = ConvexHull.computeOctRing(pts);
        if (polyPts == null) {
            return pts;
        }
        TreeSet<Coordinate> reducedSet = new TreeSet<Coordinate>();
        for (i = 0; i < polyPts.length; ++i) {
            reducedSet.add(polyPts[i]);
        }
        for (i = 0; i < pts.length; ++i) {
            if (RayCrossingCounter.isPointInRing((Coordinate)pts[i], (Coordinate[])polyPts)) continue;
            reducedSet.add(pts[i]);
        }
        Coordinate[] reducedPts = CoordinateArrays.toCoordinateArray(reducedSet);
        if (reducedPts.length < 3) {
            return ConvexHull.padArray3(reducedPts);
        }
        return reducedPts;
    }

    private static Coordinate[] padArray3(Coordinate[] pts) {
        Coordinate[] pad = new Coordinate[3];
        for (int i = 0; i < pad.length; ++i) {
            pad[i] = i < pts.length ? pts[i] : pts[0];
        }
        return pad;
    }

    private static Coordinate[] preSort(Coordinate[] pts) {
        for (int i = 1; i < pts.length; ++i) {
            if (!(pts[i].y < pts[0].y) && (pts[i].y != pts[0].y || !(pts[i].x < pts[0].x))) continue;
            Coordinate t = pts[0];
            pts[0] = pts[i];
            pts[i] = t;
        }
        Arrays.sort(pts, 1, pts.length, new RadialComparator(pts[0]));
        return pts;
    }

    private static Stack<Coordinate> grahamScan(Coordinate[] c) {
        Stack<Coordinate> ps = new Stack<Coordinate>();
        Coordinate p = ps.push(c[0]);
        p = ps.push(c[1]);
        p = ps.push(c[2]);
        for (int i = 3; i < c.length; ++i) {
            p = (Coordinate)ps.pop();
            while (!ps.empty() && CGAlgorithms.computeOrientation((Coordinate)((Coordinate)ps.peek()), (Coordinate)p, (Coordinate)c[i]) > 0) {
                p = ps.pop();
            }
            p = ps.push(p);
            p = ps.push(c[i]);
        }
        p = ps.push(c[0]);
        return ps;
    }

    private static boolean isBetween(Coordinate c1, Coordinate c2, Coordinate c3) {
        if (CGAlgorithms.computeOrientation((Coordinate)c1, (Coordinate)c2, (Coordinate)c3) != 0) {
            return false;
        }
        if (c1.x != c3.x) {
            if (c1.x <= c2.x && c2.x <= c3.x) {
                return true;
            }
            if (c3.x <= c2.x && c2.x <= c1.x) {
                return true;
            }
        }
        if (c1.y != c3.y) {
            if (c1.y <= c2.y && c2.y <= c3.y) {
                return true;
            }
            if (c3.y <= c2.y && c2.y <= c1.y) {
                return true;
            }
        }
        return false;
    }

    private static Coordinate[] computeOctRing(Coordinate[] pts) {
        Coordinate[] octPts = ConvexHull.computeOctPts(pts);
        CoordinateList coordList = new CoordinateList();
        coordList.add(octPts, false);
        if (coordList.size() < 3) {
            return null;
        }
        coordList.closeRing();
        return coordList.toCoordinateArray();
    }

    private static Coordinate[] computeOctPts(Coordinate[] pts) {
        Coordinate[] pts_ = new Coordinate[8];
        for (int j = 0; j < pts_.length; ++j) {
            pts_[j] = pts[0];
        }
        for (int i = 1; i < pts.length; ++i) {
            if (pts[i].x < pts_[0].x) {
                pts_[0] = pts[i];
            }
            if (pts[i].x - pts[i].y < pts_[1].x - pts_[1].y) {
                pts_[1] = pts[i];
            }
            if (pts[i].y > pts_[2].y) {
                pts_[2] = pts[i];
            }
            if (pts[i].x + pts[i].y > pts_[3].x + pts_[3].y) {
                pts_[3] = pts[i];
            }
            if (pts[i].x > pts_[4].x) {
                pts_[4] = pts[i];
            }
            if (pts[i].x - pts[i].y > pts_[5].x - pts_[5].y) {
                pts_[5] = pts[i];
            }
            if (pts[i].y < pts_[6].y) {
                pts_[6] = pts[i];
            }
            if (!(pts[i].x + pts[i].y < pts_[7].x + pts_[7].y)) continue;
            pts_[7] = pts[i];
        }
        return pts_;
    }

    private Geometry lineOrPolygon(Coordinate[] coords) {
        Coordinate[] coordinates = ConvexHull.cleanRing(coords);
        if (coordinates.length == 3) {
            return this.geomFactory.createLineString(new Coordinate[]{coordinates[0], coordinates[1]});
        }
        LinearRing linearRing = this.geomFactory.createLinearRing(coordinates);
        return this.geomFactory.createPolygon(linearRing, null);
    }

    private static Coordinate[] cleanRing(Coordinate[] original) {
        Assert.equals((Object)original[0], (Object)original[original.length - 1]);
        ArrayList<Coordinate> cleanedRing = new ArrayList<Coordinate>();
        Coordinate previousDistinctCoordinate = null;
        for (int i = 0; i <= original.length - 2; ++i) {
            Coordinate currentCoordinate = original[i];
            Coordinate nextCoordinate = original[i + 1];
            if (currentCoordinate.equals((Object)nextCoordinate) || previousDistinctCoordinate != null && ConvexHull.isBetween(previousDistinctCoordinate, currentCoordinate, nextCoordinate)) continue;
            cleanedRing.add(currentCoordinate);
            previousDistinctCoordinate = currentCoordinate;
        }
        cleanedRing.add(original[original.length - 1]);
        Coordinate[] cleanedRingCoordinates = new Coordinate[cleanedRing.size()];
        return cleanedRing.toArray(cleanedRingCoordinates);
    }

    private static class RadialComparator
    implements Comparator<Coordinate> {
        private Coordinate origin;

        public RadialComparator(Coordinate origin) {
            this.origin = origin;
        }

        @Override
        public int compare(Coordinate p1, Coordinate p2) {
            return RadialComparator.polarCompare(this.origin, p1, p2);
        }

        private static int polarCompare(Coordinate o, Coordinate p, Coordinate q) {
            double dxp = p.x - o.x;
            double dyp = p.y - o.y;
            double dxq = q.x - o.x;
            double dyq = q.y - o.y;
            int orient = CGAlgorithms.computeOrientation((Coordinate)o, (Coordinate)p, (Coordinate)q);
            if (orient == 1) {
                return 1;
            }
            if (orient == -1) {
                return -1;
            }
            double op = dxp * dxp + dyp * dyp;
            double oq = dxq * dxq + dyq * dyq;
            if (op < oq) {
                return -1;
            }
            if (op > oq) {
                return 1;
            }
            return 0;
        }
    }
}

