/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.operation.overlay.GeometryCollectionMapper;
import com.vividsolutions.jts.operation.overlay.snap.SnapIfNeededOverlayOp;

public class IntersectionOp {
    public static Geometry get(Geometry geom1, Geometry geom2) {
        if (geom1.isEmpty()) {
            return geom1.getFactory().createGeometryCollection(null);
        }
        if (geom2.isEmpty()) {
            return geom1.getFactory().createGeometryCollection(null);
        }
        if (IntersectionOp.isGeometryCollection(geom1)) {
            final Geometry g2 = geom2;
            return GeometryCollectionMapper.map((GeometryCollection)geom1, new GeometryCollectionMapper.MapOp(){

                @Override
                public Geometry map(Geometry g) {
                    return IntersectionOp.get(g, g2);
                }
            });
        }
        geom1.checkNotGeometryCollection();
        geom2.checkNotGeometryCollection();
        return SnapIfNeededOverlayOp.overlayOp(geom1, geom2, 1);
    }

    protected static boolean isGeometryCollection(Geometry g) {
        return g.getClass().equals(GeometryCollection.class);
    }
}

