/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.util.LineIntersector;
import com.vividsolutions.jts.geom.util.RobustLineIntersector;

public class RectangleLineIntersector {
    private LineIntersector li = new RobustLineIntersector();
    private Envelope rectEnv;
    private Coordinate diagUp0;
    private Coordinate diagUp1;
    private Coordinate diagDown0;
    private Coordinate diagDown1;

    public RectangleLineIntersector(Envelope rectEnv) {
        this.rectEnv = rectEnv;
        this.diagUp0 = new Coordinate(rectEnv.getMinX(), rectEnv.getMinY());
        this.diagUp1 = new Coordinate(rectEnv.getMaxX(), rectEnv.getMaxY());
        this.diagDown0 = new Coordinate(rectEnv.getMinX(), rectEnv.getMaxY());
        this.diagDown1 = new Coordinate(rectEnv.getMaxX(), rectEnv.getMinY());
    }

    public boolean intersects(Coordinate p0_, Coordinate p1_) {
        Coordinate p0 = p0_;
        Coordinate p1 = p1_;
        Envelope segEnv = new Envelope(p0, p1);
        if (!this.rectEnv.intersects(segEnv)) {
            return false;
        }
        if (this.rectEnv.intersects(p0)) {
            return true;
        }
        if (this.rectEnv.intersects(p1)) {
            return true;
        }
        if (p0.compareTo(p1) > 0) {
            Coordinate tmp = p0;
            p0 = p1;
            p1 = tmp;
        }
        boolean isSegUpwards = false;
        if (p1.y > p0.y) {
            isSegUpwards = true;
        }
        if (isSegUpwards) {
            this.li.computeIntersection(p0, p1, this.diagDown0, this.diagDown1);
        } else {
            this.li.computeIntersection(p0, p1, this.diagUp0, this.diagUp1);
        }
        return this.li.hasIntersection();
    }
}

