/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm.locate;

import com.vividsolutions.jts.algorithm.locate.PointOnGeometryLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryCollectionIterator;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.distance.RayCrossingCounter;

public class SimplePointInAreaLocator
implements PointOnGeometryLocator {
    private Geometry geom;

    public static int locate(Coordinate p, Geometry geom) {
        if (geom.isEmpty()) {
            return 2;
        }
        if (SimplePointInAreaLocator.containsPoint(p, geom)) {
            return 0;
        }
        return 2;
    }

    private static boolean containsPoint(Coordinate p, Geometry geom) {
        if (geom instanceof Polygon) {
            return SimplePointInAreaLocator.containsPointInPolygon(p, (Polygon)geom);
        }
        if (geom instanceof GeometryCollection) {
            GeometryCollectionIterator geomi = new GeometryCollectionIterator(geom);
            while (geomi.hasNext()) {
                Geometry g2 = geomi.next();
                if (g2 == geom || !SimplePointInAreaLocator.containsPoint(p, g2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsPointInPolygon(Coordinate p, Polygon poly) {
        if (poly.isEmpty()) {
            return false;
        }
        LinearRing shell = (LinearRing)poly.getExteriorRing();
        if (!SimplePointInAreaLocator.isPointInRing(p, shell)) {
            return false;
        }
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            LinearRing hole = (LinearRing)poly.getInteriorRingN(i);
            if (!SimplePointInAreaLocator.isPointInRing(p, hole)) continue;
            return false;
        }
        return true;
    }

    private static boolean isPointInRing(Coordinate p, LinearRing ring) {
        if (!ring.getEnvelopeInternal().intersects(p)) {
            return false;
        }
        return RayCrossingCounter.isPointInRing((Coordinate)p, (Coordinate[])ring.getCoordinates());
    }

    public SimplePointInAreaLocator(Geometry geom) {
        this.geom = geom;
    }

    @Override
    public int locate(Coordinate p) {
        return SimplePointInAreaLocator.locate(p, this.geom);
    }
}

