/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.util.Assert;
import com.vividsolutions.jts.geom.util.CGAlgorithms;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.Quadrant;
import com.vividsolutions.jts.operation.distance.BoundaryNodeRule;
import java.io.PrintStream;

public class EdgeEnd
implements Comparable {
    protected Edge edge;
    protected Label label;
    private Node node;
    private Coordinate p0;
    private Coordinate p1;
    private double dx;
    private double dy;
    private int quadrant;

    protected EdgeEnd(Edge edge) {
        this.edge = edge;
    }

    public EdgeEnd(Edge edge, Coordinate p0, Coordinate p1) {
        this(edge, p0, p1, null);
    }

    public EdgeEnd(Edge edge, Coordinate p0, Coordinate p1, Label label) {
        this(edge);
        this.init(p0, p1);
        this.label = label;
    }

    protected void init(Coordinate p0, Coordinate p1) {
        this.p0 = p0;
        this.p1 = p1;
        this.dx = p1.x - p0.x;
        this.dy = p1.y - p0.y;
        this.quadrant = Quadrant.quadrant(this.dx, this.dy);
        Assert.isTrue((this.dx != 0.0 || this.dy != 0.0 ? 1 : 0) != 0, (String)"EdgeEnd with identical endpoints found");
    }

    public Edge getEdge() {
        return this.edge;
    }

    public Label getLabel() {
        return this.label;
    }

    public Coordinate getCoordinate() {
        return this.p0;
    }

    public Coordinate getDirectedCoordinate() {
        return this.p1;
    }

    public int getQuadrant() {
        return this.quadrant;
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public int compareTo(Object obj) {
        EdgeEnd e = (EdgeEnd)obj;
        return this.compareDirection(e);
    }

    public int compareDirection(EdgeEnd e) {
        if (this.dx == e.dx && this.dy == e.dy) {
            return 0;
        }
        if (this.quadrant > e.quadrant) {
            return 1;
        }
        if (this.quadrant < e.quadrant) {
            return -1;
        }
        return CGAlgorithms.computeOrientation((Coordinate)e.p0, (Coordinate)e.p1, (Coordinate)this.p1);
    }

    public void computeLabel(BoundaryNodeRule boundaryNodeRule) {
    }

    public void print(PrintStream out) {
        double angle = Math.atan2(this.dy, this.dx);
        String className = this.getClass().getName();
        int lastDotPos = className.lastIndexOf(46);
        String name = className.substring(lastDotPos + 1);
        out.print("  " + name + ": " + this.p0 + " - " + this.p1 + " " + this.quadrant + ":" + angle + "   " + this.label);
    }
}

