/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.algorithm.locate.IndexedPointInAreaLocator;
import com.vividsolutions.jts.algorithm.locate.PointOnGeometryLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.util.Assert;
import com.vividsolutions.jts.geom.util.CGAlgorithms;
import com.vividsolutions.jts.geom.util.LineIntersector;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.geomgraph.index.EdgeSetIntersector;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import com.vividsolutions.jts.geomgraph.index.SimpleMCSweepLineIntersector;
import com.vividsolutions.jts.operation.distance.BoundaryNodeRule;
import com.vividsolutions.jts.operation.distance.PointLocator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GeometryGraph
extends PlanarGraph {
    private Geometry parentGeom;
    private Map lineEdgeMap = new HashMap();
    private BoundaryNodeRule boundaryNodeRule = null;
    private boolean useBoundaryDeterminationRule = true;
    private int argIndex;
    private Collection boundaryNodes;
    private boolean hasTooFewPoints = false;
    private Coordinate invalidPoint = null;
    private PointOnGeometryLocator areaPtLocator = null;
    private final PointLocator ptLocator = new PointLocator();

    public static int determineBoundary(BoundaryNodeRule boundaryNodeRule, int boundaryCount) {
        return boundaryNodeRule.isInBoundary(boundaryCount) ? 1 : 0;
    }

    private EdgeSetIntersector createEdgeSetIntersector() {
        return new SimpleMCSweepLineIntersector();
    }

    public GeometryGraph(int argIndex, Geometry parentGeom) {
        this(argIndex, parentGeom, BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE);
    }

    public GeometryGraph(int argIndex, Geometry parentGeom, BoundaryNodeRule boundaryNodeRule) {
        this.argIndex = argIndex;
        this.parentGeom = parentGeom;
        this.boundaryNodeRule = boundaryNodeRule;
        if (parentGeom != null) {
            this.add(parentGeom);
        }
    }

    public boolean hasTooFewPoints() {
        return this.hasTooFewPoints;
    }

    public Coordinate getInvalidPoint() {
        return this.invalidPoint;
    }

    public Geometry getGeometry() {
        return this.parentGeom;
    }

    public BoundaryNodeRule getBoundaryNodeRule() {
        return this.boundaryNodeRule;
    }

    public Collection getBoundaryNodes() {
        if (this.boundaryNodes == null) {
            this.boundaryNodes = this.nodes.getBoundaryNodes(this.argIndex);
        }
        return this.boundaryNodes;
    }

    public Coordinate[] getBoundaryPoints() {
        Collection coll = this.getBoundaryNodes();
        Coordinate[] pts = new Coordinate[coll.size()];
        int i = 0;
        for (Node node : coll) {
            pts[i++] = (Coordinate)node.getCoordinate().clone();
        }
        return pts;
    }

    public Edge findEdge(LineString line) {
        return (Edge)this.lineEdgeMap.get(line);
    }

    public void computeSplitEdges(List edgelist) {
        for (Edge e : this.edges) {
            e.eiList.addSplitEdges(edgelist);
        }
    }

    private void add(Geometry g) {
        if (g.isEmpty()) {
            return;
        }
        if (g instanceof MultiPolygon) {
            this.useBoundaryDeterminationRule = false;
        }
        if (g instanceof Polygon) {
            this.addPolygon((Polygon)g);
        } else if (g instanceof LineString) {
            this.addLineString((LineString)g);
        } else if (g instanceof Point) {
            this.addPoint((Point)g);
        } else if (g instanceof MultiPoint) {
            this.addCollection((GeometryCollection)((MultiPoint)g));
        } else if (g instanceof MultiLineString) {
            this.addCollection((GeometryCollection)((MultiLineString)g));
        } else if (g instanceof MultiPolygon) {
            this.addCollection((GeometryCollection)((MultiPolygon)g));
        } else if (g instanceof GeometryCollection) {
            this.addCollection((GeometryCollection)g);
        } else {
            throw new UnsupportedOperationException(g.getClass().getName());
        }
    }

    private void addCollection(GeometryCollection gc) {
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g = gc.getGeometryN(i);
            this.add(g);
        }
    }

    private void addPoint(Point p) {
        Coordinate coord = p.getCoordinate();
        this.insertPoint(this.argIndex, coord, 0);
    }

    private void addPolygonRing(LinearRing lr, int cwLeft, int cwRight) {
        if (lr.isEmpty()) {
            return;
        }
        Coordinate[] coord = CoordinateArrays.removeRepeatedPoints((Coordinate[])lr.getCoordinates());
        if (coord.length < 4) {
            this.hasTooFewPoints = true;
            this.invalidPoint = coord[0];
            return;
        }
        int left = cwLeft;
        int right = cwRight;
        if (CGAlgorithms.isCCW((Coordinate[])coord)) {
            left = cwRight;
            right = cwLeft;
        }
        Edge e = new Edge(coord, new Label(this.argIndex, 1, left, right));
        this.lineEdgeMap.put(lr, e);
        this.insertEdge(e);
        this.insertPoint(this.argIndex, coord[0], 1);
    }

    private void addPolygon(Polygon p) {
        this.addPolygonRing((LinearRing)p.getExteriorRing(), 2, 0);
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            LinearRing hole = (LinearRing)p.getInteriorRingN(i);
            this.addPolygonRing(hole, 0, 2);
        }
    }

    private void addLineString(LineString line) {
        Coordinate[] coord = CoordinateArrays.removeRepeatedPoints((Coordinate[])line.getCoordinates());
        if (coord.length < 2) {
            this.hasTooFewPoints = true;
            this.invalidPoint = coord[0];
            return;
        }
        Edge e = new Edge(coord, new Label(this.argIndex, 0));
        this.lineEdgeMap.put(line, e);
        this.insertEdge(e);
        Assert.isTrue((coord.length >= 2 ? 1 : 0) != 0, (String)"found LineString with single point");
        this.insertBoundaryPoint(this.argIndex, coord[0]);
        this.insertBoundaryPoint(this.argIndex, coord[coord.length - 1]);
    }

    public void addEdge(Edge e) {
        this.insertEdge(e);
        Coordinate[] coord = e.getCoordinates();
        this.insertPoint(this.argIndex, coord[0], 1);
        this.insertPoint(this.argIndex, coord[coord.length - 1], 1);
    }

    public void addPoint(Coordinate pt) {
        this.insertPoint(this.argIndex, pt, 0);
    }

    public SegmentIntersector computeSelfNodes(LineIntersector li, boolean computeRingSelfNodes) {
        SegmentIntersector si = new SegmentIntersector(li, true, false);
        EdgeSetIntersector esi = this.createEdgeSetIntersector();
        if (!computeRingSelfNodes && (this.parentGeom instanceof LinearRing || this.parentGeom instanceof Polygon || this.parentGeom instanceof MultiPolygon)) {
            esi.computeIntersections(this.edges, si, false);
        } else {
            esi.computeIntersections(this.edges, si, true);
        }
        this.addSelfIntersectionNodes(this.argIndex);
        return si;
    }

    public SegmentIntersector computeEdgeIntersections(GeometryGraph g, LineIntersector li, boolean includeProper) {
        SegmentIntersector si = new SegmentIntersector(li, includeProper, true);
        si.setBoundaryNodes(this.getBoundaryNodes(), g.getBoundaryNodes());
        EdgeSetIntersector esi = this.createEdgeSetIntersector();
        esi.computeIntersections(this.edges, g.edges, si);
        return si;
    }

    private void insertPoint(int argIndex, Coordinate coord, int onLocation) {
        Node n = this.nodes.addNode(coord);
        Label lbl = n.getLabel();
        if (lbl == null) {
            n.label = new Label(argIndex, onLocation);
        } else {
            lbl.setLocation(argIndex, onLocation);
        }
    }

    private void insertBoundaryPoint(int argIndex, Coordinate coord) {
        Node n = this.nodes.addNode(coord);
        Label lbl = n.getLabel();
        int boundaryCount = 1;
        int loc = -1;
        loc = lbl.getLocation(argIndex, 0);
        if (loc == 1) {
            ++boundaryCount;
        }
        int newLoc = GeometryGraph.determineBoundary(this.boundaryNodeRule, boundaryCount);
        lbl.setLocation(argIndex, newLoc);
    }

    private void addSelfIntersectionNodes(int argIndex) {
        for (Edge e : this.edges) {
            int eLoc = e.getLabel().getLocation(argIndex);
            Iterator eiIt = e.eiList.iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei = (EdgeIntersection)eiIt.next();
                this.addSelfIntersectionNode(argIndex, ei.coord, eLoc);
            }
        }
    }

    private void addSelfIntersectionNode(int argIndex, Coordinate coord, int loc) {
        if (this.isBoundaryNode(argIndex, coord)) {
            return;
        }
        if (loc == 1 && this.useBoundaryDeterminationRule) {
            this.insertBoundaryPoint(argIndex, coord);
        } else {
            this.insertPoint(argIndex, coord, loc);
        }
    }

    public int locate(Coordinate pt) {
        if (this.parentGeom instanceof Polygonal && this.parentGeom.getNumGeometries() > 50) {
            if (this.areaPtLocator == null) {
                this.areaPtLocator = new IndexedPointInAreaLocator(this.parentGeom);
            }
            return this.areaPtLocator.locate(pt);
        }
        return this.ptLocator.locate(pt, this.parentGeom);
    }
}

