/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Location;

public class TopologyLocation {
    int[] location;

    public TopologyLocation(int[] location) {
        this.init(location.length);
    }

    public TopologyLocation(int on, int left, int right) {
        this.init(3);
        this.location[0] = on;
        this.location[1] = left;
        this.location[2] = right;
    }

    public TopologyLocation(int on) {
        this.init(1);
        this.location[0] = on;
    }

    public TopologyLocation(TopologyLocation gl) {
        this.init(gl.location.length);
        if (gl != null) {
            for (int i = 0; i < this.location.length; ++i) {
                this.location[i] = gl.location[i];
            }
        }
    }

    private void init(int size) {
        this.location = new int[size];
        this.setAllLocations(-1);
    }

    public int get(int posIndex) {
        if (posIndex < this.location.length) {
            return this.location[posIndex];
        }
        return -1;
    }

    public boolean isNull() {
        for (int i = 0; i < this.location.length; ++i) {
            if (this.location[i] == -1) continue;
            return false;
        }
        return true;
    }

    public boolean isAnyNull() {
        for (int i = 0; i < this.location.length; ++i) {
            if (this.location[i] != -1) continue;
            return true;
        }
        return false;
    }

    public boolean isEqualOnSide(TopologyLocation le, int locIndex) {
        return this.location[locIndex] == le.location[locIndex];
    }

    public boolean isArea() {
        return this.location.length > 1;
    }

    public boolean isLine() {
        return this.location.length == 1;
    }

    public void flip() {
        if (this.location.length <= 1) {
            return;
        }
        int temp = this.location[1];
        this.location[1] = this.location[2];
        this.location[2] = temp;
    }

    public void setAllLocations(int locValue) {
        for (int i = 0; i < this.location.length; ++i) {
            this.location[i] = locValue;
        }
    }

    public void setAllLocationsIfNull(int locValue) {
        for (int i = 0; i < this.location.length; ++i) {
            if (this.location[i] != -1) continue;
            this.location[i] = locValue;
        }
    }

    public void setLocation(int locIndex, int locValue) {
        this.location[locIndex] = locValue;
    }

    public void setLocation(int locValue) {
        this.setLocation(0, locValue);
    }

    public int[] getLocations() {
        return this.location;
    }

    public void setLocations(int on, int left, int right) {
        this.location[0] = on;
        this.location[1] = left;
        this.location[2] = right;
    }

    public boolean allPositionsEqual(int loc) {
        for (int i = 0; i < this.location.length; ++i) {
            if (this.location[i] == loc) continue;
            return false;
        }
        return true;
    }

    public void merge(TopologyLocation gl) {
        if (gl.location.length > this.location.length) {
            int[] newLoc = new int[]{this.location[0], -1, -1};
            this.location = newLoc;
        }
        for (int i = 0; i < this.location.length; ++i) {
            if (this.location[i] != -1 || i >= gl.location.length) continue;
            this.location[i] = gl.location[i];
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.location.length > 1) {
            buf.append(Location.toLocationSymbol((int)this.location[1]));
        }
        buf.append(Location.toLocationSymbol((int)this.location[0]));
        if (this.location.length > 1) {
            buf.append(Location.toLocationSymbol((int)this.location[2]));
        }
        return buf.toString();
    }
}

