/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph.index;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.index.EdgeSetIntersector;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import com.vividsolutions.jts.geomgraph.index.SweepLineEvent;
import com.vividsolutions.jts.geomgraph.index.SweepLineSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleSweepLineIntersector
extends EdgeSetIntersector {
    List events = new ArrayList();
    int nOverlaps;

    @Override
    public void computeIntersections(List edges, SegmentIntersector si, boolean testAllSegments) {
        if (testAllSegments) {
            this.add(edges, null);
        } else {
            this.add(edges);
        }
        this.computeIntersections(si);
    }

    @Override
    public void computeIntersections(List edges0, List edges1, SegmentIntersector si) {
        this.add(edges0, (Object)edges0);
        this.add(edges1, (Object)edges1);
        this.computeIntersections(si);
    }

    private void add(List edges) {
        for (Edge edge : edges) {
            this.add(edge, (Object)edge);
        }
    }

    private void add(List edges, Object edgeSet) {
        for (Edge edge : edges) {
            this.add(edge, edgeSet);
        }
    }

    private void add(Edge edge, Object edgeSet) {
        Coordinate[] pts = edge.getCoordinates();
        for (int i = 0; i < pts.length - 1; ++i) {
            SweepLineSegment ss = new SweepLineSegment(edge, i);
            SweepLineEvent insertEvent = new SweepLineEvent(edgeSet, ss.getMinX(), null, ss);
            this.events.add(insertEvent);
            this.events.add(new SweepLineEvent(edgeSet, ss.getMaxX(), insertEvent, ss));
        }
    }

    private void prepareEvents() {
        Collections.sort(this.events);
        for (int i = 0; i < this.events.size(); ++i) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i);
            if (!ev.isDelete()) continue;
            ev.getInsertEvent().setDeleteEventIndex(i);
        }
    }

    private void computeIntersections(SegmentIntersector si) {
        this.nOverlaps = 0;
        this.prepareEvents();
        for (int i = 0; i < this.events.size(); ++i) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i);
            if (!ev.isInsert()) continue;
            this.processOverlaps(i, ev.getDeleteEventIndex(), ev, si);
        }
    }

    private void processOverlaps(int start, int end, SweepLineEvent ev0, SegmentIntersector si) {
        SweepLineSegment ss0 = (SweepLineSegment)ev0.getObject();
        for (int i = start; i < end; ++i) {
            SweepLineEvent ev1 = (SweepLineEvent)this.events.get(i);
            if (!ev1.isInsert()) continue;
            SweepLineSegment ss1 = (SweepLineSegment)ev1.getObject();
            if (ev0.edgeSet != null && ev0.edgeSet == ev1.edgeSet) continue;
            ss0.computeIntersections(ss1, si);
            ++this.nOverlaps;
        }
    }
}

