/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.bintree;

public class Interval {
    public double min;
    public double max;

    public Interval() {
        this.min = 0.0;
        this.max = 0.0;
    }

    public Interval(double min, double max) {
        this.init(min, max);
    }

    public Interval(Interval interval) {
        this.init(interval.min, interval.max);
    }

    public void init(double min_, double max_) {
        this.min = min_;
        this.max = max_;
        if (min_ > max_) {
            this.min = max_;
            this.max = min_;
        }
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getWidth() {
        return this.max - this.min;
    }

    public void expandToInclude(Interval interval) {
        if (interval.max > this.max) {
            this.max = interval.max;
        }
        if (interval.min < this.min) {
            this.min = interval.min;
        }
    }

    public boolean overlaps(Interval interval) {
        return this.overlaps(interval.min, interval.max);
    }

    public boolean overlaps(double min_, double max_) {
        return !(this.min > max_) && !(this.max < min_);
    }

    public boolean contains(Interval interval) {
        return this.contains(interval.min, interval.max);
    }

    public boolean contains(double min_, double max_) {
        return min_ >= this.min && max_ <= this.max;
    }

    public boolean contains(double p) {
        return p >= this.min && p <= this.max;
    }

    public String toString() {
        return "[" + this.min + ", " + this.max + "]";
    }
}

