/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.intervalrtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.util.WKTWriter;
import com.vividsolutions.jts.index.ItemVisitor;
import java.util.Comparator;

public abstract class IntervalRTreeNode {
    protected double min = Double.POSITIVE_INFINITY;
    protected double max = Double.NEGATIVE_INFINITY;

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public abstract void query(double var1, double var3, ItemVisitor var5);

    protected boolean intersects(double queryMin, double queryMax) {
        return !(this.min > queryMax) && !(this.max < queryMin);
    }

    public String toString() {
        return WKTWriter.toLineString((Coordinate)new Coordinate(this.min, 0.0), (Coordinate)new Coordinate(this.max, 0.0));
    }

    public static class NodeComparator
    implements Comparator<IntervalRTreeNode> {
        @Override
        public int compare(IntervalRTreeNode n1, IntervalRTreeNode n2) {
            double mid1 = (n1.min + n1.max) / 2.0;
            double mid2 = (n2.min + n2.max) / 2.0;
            if (mid1 < mid2) {
                return -1;
            }
            if (mid1 > mid2) {
                return 1;
            }
            return 0;
        }
    }
}

