/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.intervalrtree;

import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.intervalrtree.IntervalRTreeBranchNode;
import com.vividsolutions.jts.index.intervalrtree.IntervalRTreeLeafNode;
import com.vividsolutions.jts.index.intervalrtree.IntervalRTreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SortedPackedIntervalRTree {
    private List<IntervalRTreeNode> leaves = new ArrayList<IntervalRTreeNode>();
    private IntervalRTreeNode root = null;

    public void insert(double min, double max, Object item) {
        if (this.root != null) {
            throw new IllegalStateException("Index cannot be added to once it has been queried");
        }
        this.leaves.add(new IntervalRTreeLeafNode(min, max, item));
    }

    private void init() {
        if (this.root != null) {
            return;
        }
        this.root = this.buildTree();
    }

    private IntervalRTreeNode buildTree() {
        Collections.sort(this.leaves, new IntervalRTreeNode.NodeComparator());
        List<IntervalRTreeNode> src = this.leaves;
        List<IntervalRTreeNode> temp = null;
        List<IntervalRTreeNode> dest = new ArrayList<IntervalRTreeNode>();
        while (true) {
            SortedPackedIntervalRTree.buildLevel(src, dest);
            if (dest.size() == 1) {
                return (IntervalRTreeNode)dest.get(0);
            }
            temp = src;
            src = dest;
            dest = temp;
        }
    }

    private static void buildLevel(List<IntervalRTreeNode> src, List<IntervalRTreeNode> dest) {
        dest.clear();
        for (int i = 0; i < src.size(); i += 2) {
            IntervalRTreeNode n2;
            IntervalRTreeNode n1 = src.get(i);
            IntervalRTreeNode intervalRTreeNode = n2 = i + 1 < src.size() ? src.get(i) : null;
            if (n2 == null) {
                dest.add(n1);
                continue;
            }
            IntervalRTreeBranchNode node = new IntervalRTreeBranchNode(src.get(i), src.get(i + 1));
            dest.add(node);
        }
    }

    public void query(double min, double max, ItemVisitor visitor) {
        this.init();
        this.root.query(min, max, visitor);
    }
}

