/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.sweepline;

import com.vividsolutions.jts.index.sweepline.SweepLineEvent;
import com.vividsolutions.jts.index.sweepline.SweepLineInterval;
import com.vividsolutions.jts.index.sweepline.SweepLineOverlapAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SweepLineIndex {
    List<SweepLineEvent> events = new ArrayList<SweepLineEvent>();
    private boolean indexBuilt;

    public void add(SweepLineInterval sweepInt) {
        SweepLineEvent insertEvent = new SweepLineEvent(sweepInt.getMin(), null, sweepInt);
        this.events.add(insertEvent);
        this.events.add(new SweepLineEvent(sweepInt.getMax(), insertEvent, sweepInt));
    }

    private void buildIndex() {
        if (this.indexBuilt) {
            return;
        }
        Collections.sort(this.events);
        int i = 0;
        for (SweepLineEvent ev : this.events) {
            if (ev.isDelete()) {
                ev.getInsertEvent().setDeleteEventIndex(i);
            }
            ++i;
        }
        this.indexBuilt = true;
    }

    public void computeOverlaps(SweepLineOverlapAction action) {
        this.buildIndex();
        int i = 0;
        for (SweepLineEvent ev : this.events) {
            if (ev.isInsert()) {
                this.processOverlaps(i, ev.getDeleteEventIndex(), ev.getInterval(), action);
            }
            ++i;
        }
    }

    private void processOverlaps(int start, int end, SweepLineInterval s0, SweepLineOverlapAction action) {
        for (int i = start; i < end; ++i) {
            SweepLineEvent ev = this.events.get(i);
            if (!ev.isInsert()) continue;
            SweepLineInterval s1 = ev.getInterval();
            action.overlap(s0, s1);
        }
    }
}

