/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.TopologyException;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.LineIntersector;
import com.vividsolutions.jts.geom.util.RobustLineIntersector;
import com.vividsolutions.jts.noding.IntersectionAdder;
import com.vividsolutions.jts.noding.MCIndexNoder;
import com.vividsolutions.jts.noding.Noder;
import java.util.Collection;

public class IteratedNoder
implements Noder {
    public static final int MAX_ITER = 5;
    private PrecisionModel pm;
    private LineIntersector li = new RobustLineIntersector();
    private Collection nodedSegStrings;
    private int maxIter = 5;

    public IteratedNoder(PrecisionModel pm) {
        this.pm = pm;
        this.li.setPrecisionModel(pm);
    }

    public void setMaximumIterations(int maxIter) {
        this.maxIter = maxIter;
    }

    @Override
    public Collection getNodedSubstrings() {
        return this.nodedSegStrings;
    }

    @Override
    public void computeNodes(Collection segStrings) throws TopologyException {
        int nodesCreated;
        int[] numInteriorIntersections = new int[1];
        this.nodedSegStrings = segStrings;
        int nodingIterationCount = 0;
        int lastNodesCreated = -1;
        do {
            this.node(this.nodedSegStrings, numInteriorIntersections);
            nodesCreated = numInteriorIntersections[0];
            if (lastNodesCreated <= 0 || nodesCreated < lastNodesCreated || ++nodingIterationCount <= this.maxIter) continue;
            throw new TopologyException("Iterated noding failed to converge after " + nodingIterationCount + " iterations");
        } while ((lastNodesCreated = nodesCreated) > 0);
    }

    private void node(Collection segStrings, int[] numInteriorIntersections) {
        IntersectionAdder si = new IntersectionAdder(this.li);
        MCIndexNoder noder = new MCIndexNoder();
        noder.setSegmentIntersector(si);
        noder.computeNodes(segStrings);
        this.nodedSegStrings = noder.getNodedSubstrings();
        numInteriorIntersections[0] = si.numInteriorIntersections;
    }
}

