/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.util.LineIntersector;
import com.vividsolutions.jts.geom.util.RobustLineIntersector;
import com.vividsolutions.jts.noding.SegmentString;
import java.util.Collection;

public class NodingValidator {
    private LineIntersector li = new RobustLineIntersector();
    private Collection segStrings;

    public NodingValidator(Collection segStrings) {
        this.segStrings = segStrings;
    }

    public void checkValid() {
        this.checkEndPtVertexIntersections();
        this.checkInteriorIntersections();
        this.checkCollapses();
    }

    private void checkCollapses() {
        for (SegmentString ss : this.segStrings) {
            this.checkCollapses(ss);
        }
    }

    private void checkCollapses(SegmentString ss) {
        Coordinate[] pts = ss.getCoordinates();
        for (int i = 0; i < pts.length - 2; ++i) {
            NodingValidator.checkCollapse(pts[i], pts[i + 1], pts[i + 2]);
        }
    }

    private static void checkCollapse(Coordinate p0, Coordinate p1, Coordinate p2) {
        if (p0.equals((Object)p2)) {
            throw new RuntimeException("found non-noded collapse at " + new GeometryFactory().createLineString(new Coordinate[]{p0, p1, p2}));
        }
    }

    private void checkInteriorIntersections() {
        for (SegmentString ss0 : this.segStrings) {
            for (SegmentString ss1 : this.segStrings) {
                this.checkInteriorIntersections(ss0, ss1);
            }
        }
    }

    private void checkInteriorIntersections(SegmentString ss0, SegmentString ss1) {
        Coordinate[] pts0 = ss0.getCoordinates();
        Coordinate[] pts1 = ss1.getCoordinates();
        for (int i0 = 0; i0 < pts0.length - 1; ++i0) {
            for (int i1 = 0; i1 < pts1.length - 1; ++i1) {
                this.checkInteriorIntersections(ss0, i0, ss1, i1);
            }
        }
    }

    private void checkInteriorIntersections(SegmentString e0, int segIndex0, SegmentString e1, int segIndex1) {
        if (e0 == e1 && segIndex0 == segIndex1) {
            return;
        }
        Coordinate p00 = e0.getCoordinates()[segIndex0];
        Coordinate p01 = e0.getCoordinates()[segIndex0 + 1];
        Coordinate p10 = e1.getCoordinates()[segIndex1];
        Coordinate p11 = e1.getCoordinates()[segIndex1 + 1];
        this.li.computeIntersection(p00, p01, p10, p11);
        if (this.li.hasIntersection() && (this.li.isProper() || this.hasInteriorIntersection(this.li, p00, p01) || this.hasInteriorIntersection(this.li, p10, p11))) {
            throw new RuntimeException("found non-noded intersection at " + p00 + "-" + p01 + " and " + p10 + "-" + p11);
        }
    }

    private boolean hasInteriorIntersection(LineIntersector li, Coordinate p0, Coordinate p1) {
        for (int i = 0; i < li.getIntersectionNum(); ++i) {
            Coordinate intPt = li.getIntersection(i);
            if (intPt.equals((Object)p0) || intPt.equals((Object)p1)) continue;
            return true;
        }
        return false;
    }

    private void checkEndPtVertexIntersections() {
        for (SegmentString ss : this.segStrings) {
            Coordinate[] pts = ss.getCoordinates();
            this.checkEndPtVertexIntersections(pts[0], this.segStrings);
            this.checkEndPtVertexIntersections(pts[pts.length - 1], this.segStrings);
        }
    }

    private void checkEndPtVertexIntersections(Coordinate testPt, Collection segStrings) {
        for (SegmentString ss : segStrings) {
            Coordinate[] pts = ss.getCoordinates();
            for (int j = 1; j < pts.length - 1; ++j) {
                if (!pts[j].equals((Object)testPt)) continue;
                throw new RuntimeException("found endpt/interior pt intersection at index " + j + " :pt " + testPt);
            }
        }
    }
}

