/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.util.Assert;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.SegmentNode;
import com.vividsolutions.jts.noding.SegmentString;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SegmentNodeList {
    private Map nodeMap = new TreeMap();
    private NodedSegmentString edge;

    public SegmentNodeList(NodedSegmentString edge) {
        this.edge = edge;
    }

    public NodedSegmentString getEdge() {
        return this.edge;
    }

    public SegmentNode add(Coordinate intPt, int segmentIndex) {
        SegmentNode eiNew = new SegmentNode(this.edge, intPt, segmentIndex, this.edge.getSegmentOctant(segmentIndex));
        SegmentNode ei = (SegmentNode)this.nodeMap.get(eiNew);
        if (ei != null) {
            Assert.isTrue((boolean)ei.coord.equals2D(intPt), (String)"Found equal nodes with different coordinates");
            return ei;
        }
        this.nodeMap.put(eiNew, eiNew);
        return eiNew;
    }

    public Iterator<SegmentNode> iterator() {
        return this.nodeMap.values().iterator();
    }

    private void addEndpoints() {
        int maxSegIndex = this.edge.size() - 1;
        this.add(this.edge.getCoordinate(0), 0);
        this.add(this.edge.getCoordinate(maxSegIndex), maxSegIndex);
    }

    private void addCollapsedNodes() {
        ArrayList<Integer> collapsedVertexIndexes = new ArrayList<Integer>();
        this.findCollapsesFromInsertedNodes(collapsedVertexIndexes);
        this.findCollapsesFromExistingVertices(collapsedVertexIndexes);
        Iterator it = collapsedVertexIndexes.iterator();
        while (it.hasNext()) {
            int vertexIndex = (Integer)it.next();
            this.add(this.edge.getCoordinate(vertexIndex), vertexIndex);
        }
    }

    private void findCollapsesFromExistingVertices(List<Integer> collapsedVertexIndexes) {
        for (int i = 0; i < this.edge.size() - 2; ++i) {
            Coordinate p2;
            Coordinate p0 = this.edge.getCoordinate(i);
            if (!p0.equals2D(p2 = this.edge.getCoordinate(i + 2))) continue;
            collapsedVertexIndexes.add(new Integer(i + 1));
        }
    }

    private void findCollapsesFromInsertedNodes(List<Integer> collapsedVertexIndexes) {
        int[] collapsedVertexIndex = new int[1];
        Iterator<SegmentNode> it = this.iterator();
        SegmentNode eiPrev = it.next();
        while (it.hasNext()) {
            SegmentNode ei = it.next();
            boolean isCollapsed = this.findCollapseIndex(eiPrev, ei, collapsedVertexIndex);
            if (isCollapsed) {
                collapsedVertexIndexes.add(new Integer(collapsedVertexIndex[0]));
            }
            eiPrev = ei;
        }
    }

    private boolean findCollapseIndex(SegmentNode ei0, SegmentNode ei1, int[] collapsedVertexIndex) {
        if (!ei0.coord.equals2D(ei1.coord)) {
            return false;
        }
        int numVerticesBetween = ei1.segmentIndex - ei0.segmentIndex;
        if (!ei1.isInterior()) {
            --numVerticesBetween;
        }
        if (numVerticesBetween == 1) {
            collapsedVertexIndex[0] = ei0.segmentIndex + 1;
            return true;
        }
        return false;
    }

    public void addSplitEdges(Collection<SegmentString> edgeList) {
        this.addEndpoints();
        this.addCollapsedNodes();
        Iterator<SegmentNode> it = this.iterator();
        SegmentNode eiPrev = it.next();
        while (it.hasNext()) {
            SegmentNode ei = it.next();
            SegmentString newEdge = this.createSplitEdge(eiPrev, ei);
            edgeList.add(newEdge);
            eiPrev = ei;
        }
    }

    private void checkSplitEdgesCorrectness(List splitEdges) {
        Coordinate[] edgePts = this.edge.getCoordinates();
        SegmentString split0 = (SegmentString)splitEdges.get(0);
        Coordinate pt0 = split0.getCoordinate(0);
        if (!pt0.equals2D(edgePts[0])) {
            throw new RuntimeException("bad split edge start point at " + pt0);
        }
        SegmentString splitn = (SegmentString)splitEdges.get(splitEdges.size() - 1);
        Coordinate[] splitnPts = splitn.getCoordinates();
        Coordinate ptn = splitnPts[splitnPts.length - 1];
        if (!ptn.equals2D(edgePts[edgePts.length - 1])) {
            throw new RuntimeException("bad split edge end point at " + ptn);
        }
    }

    SegmentString createSplitEdge(SegmentNode ei0, SegmentNode ei1) {
        boolean useIntPt1;
        int npts = ei1.segmentIndex - ei0.segmentIndex + 2;
        Coordinate lastSegStartPt = this.edge.getCoordinate(ei1.segmentIndex);
        boolean bl = useIntPt1 = ei1.isInterior() || !ei1.coord.equals2D(lastSegStartPt);
        if (!useIntPt1) {
            --npts;
        }
        Coordinate[] pts = new Coordinate[npts];
        int ipt = 0;
        pts[ipt++] = new Coordinate(ei0.coord);
        for (int i = ei0.segmentIndex + 1; i <= ei1.segmentIndex; ++i) {
            pts[ipt++] = this.edge.getCoordinate(i);
        }
        if (useIntPt1) {
            pts[ipt] = ei1.coord;
        }
        return new NodedSegmentString(pts, this.edge.getData());
    }

    public void print(PrintStream out) {
        out.println("Intersections:");
        Iterator<SegmentNode> it = this.iterator();
        while (it.hasNext()) {
            SegmentNode ei = it.next();
            ei.print(out);
        }
    }
}

