/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.relate;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.GeometryGraphOperation;
import com.vividsolutions.jts.operation.distance.BoundaryNodeRule;
import com.vividsolutions.jts.operation.relate.RectangleContains;
import com.vividsolutions.jts.operation.relate.RectangleIntersects;
import com.vividsolutions.jts.operation.relate.RelateComputer;

public class RelateOp
extends GeometryGraphOperation {
    private RelateComputer relate;

    public static IntersectionMatrix relate(Geometry a, Geometry b) {
        RelateOp relOp = new RelateOp(a, b);
        IntersectionMatrix im = relOp.getIntersectionMatrix();
        return im;
    }

    public static IntersectionMatrix relate(Geometry a, Geometry b, BoundaryNodeRule boundaryNodeRule) {
        RelateOp relOp = new RelateOp(a, b, boundaryNodeRule);
        IntersectionMatrix im = relOp.getIntersectionMatrix();
        return im;
    }

    public RelateOp(Geometry g0, Geometry g1) {
        super(g0, g1);
        this.relate = new RelateComputer(this.arg);
    }

    public RelateOp(Geometry g0, Geometry g1, BoundaryNodeRule boundaryNodeRule) {
        super(g0, g1, boundaryNodeRule);
        this.relate = new RelateComputer(this.arg);
    }

    public IntersectionMatrix getIntersectionMatrix() {
        return this.relate.computeIM();
    }

    public static boolean disjoint(Geometry g1, Geometry g) {
        return !RelateOp.intersects(g1, g);
    }

    public static boolean touches(Geometry g1, Geometry g) {
        if (!g1.getEnvelopeInternal().intersects(g.getEnvelopeInternal())) {
            return false;
        }
        return RelateOp.relate(g1, g).isTouches(g1.getDimension(), g.getDimension());
    }

    public static boolean intersects(Geometry g1, Geometry g) {
        if (!g1.getEnvelopeInternal().intersects(g.getEnvelopeInternal())) {
            return false;
        }
        if (g1.isRectangle()) {
            return RectangleIntersects.intersects((Polygon)g1, g);
        }
        if (g.isRectangle()) {
            return RectangleIntersects.intersects((Polygon)g, g1);
        }
        return RelateOp.relate(g1, g).isIntersects();
    }

    public static boolean crosses(Geometry g1, Geometry g) {
        if (!g1.getEnvelopeInternal().intersects(g.getEnvelopeInternal())) {
            return false;
        }
        return RelateOp.relate(g1, g).isCrosses(g1.getDimension(), g.getDimension());
    }

    public static boolean within(Geometry g1, Geometry g) {
        return RelateOp.contains(g, g1);
    }

    public static boolean contains(Geometry g1, Geometry g) {
        if (!g1.getEnvelopeInternal().contains(g.getEnvelopeInternal())) {
            return false;
        }
        if (g1.isRectangle()) {
            return RectangleContains.contains((Polygon)g1, g);
        }
        return RelateOp.relate(g1, g).isContains();
    }

    public static boolean overlaps(Geometry g1, Geometry g) {
        if (!g1.getEnvelopeInternal().intersects(g.getEnvelopeInternal())) {
            return false;
        }
        return RelateOp.relate(g1, g).isOverlaps(g1.getDimension(), g.getDimension());
    }

    public static boolean covers(Geometry g1, Geometry g) {
        if (!g1.getEnvelopeInternal().covers(g.getEnvelopeInternal())) {
            return false;
        }
        if (g1.isRectangle()) {
            return true;
        }
        return RelateOp.relate(g1, g).isCovers();
    }

    public static boolean coveredBy(Geometry g1, Geometry g) {
        return RelateOp.covers(g, g1);
    }

    public static boolean equals(Geometry g1, Geometry g) {
        return RelateOp.equalsTopo(g1, g);
    }

    public static boolean equalsTopo(Geometry g1, Geometry g) {
        if (!g1.getEnvelopeInternal().equals((Object)g.getEnvelopeInternal())) {
            return false;
        }
        return RelateOp.relate(g1, g).isEquals(g1.getDimension(), g.getDimension());
    }

    public static boolean relate(Geometry g1, Geometry g, String intersectionPattern) {
        return RelateOp.relate(g1, g).matches(intersectionPattern);
    }
}

