/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

public class RepeatedPointTester {
    private Coordinate repeatedCoord;

    public Coordinate getCoordinate() {
        return this.repeatedCoord;
    }

    public boolean hasRepeatedPoint(Geometry g) {
        if (g.isEmpty()) {
            return false;
        }
        if (g instanceof Point) {
            return false;
        }
        if (g instanceof MultiPoint) {
            return false;
        }
        if (g instanceof LineString) {
            return this.hasRepeatedPoint(((LineString)g).getCoordinates());
        }
        if (g instanceof Polygon) {
            return this.hasRepeatedPoint((Polygon)g);
        }
        if (g instanceof GeometryCollection) {
            return this.hasRepeatedPoint((GeometryCollection)g);
        }
        throw new UnsupportedOperationException(g.getClass().getName());
    }

    public boolean hasRepeatedPoint(Coordinate[] coord) {
        for (int i = 1; i < coord.length; ++i) {
            if (!coord[i - 1].equals((Object)coord[i])) continue;
            this.repeatedCoord = coord[i];
            return true;
        }
        return false;
    }

    private boolean hasRepeatedPoint(Polygon p) {
        if (this.hasRepeatedPoint(p.getExteriorRing().getCoordinates())) {
            return true;
        }
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            if (!this.hasRepeatedPoint(p.getInteriorRingN(i).getCoordinates())) continue;
            return true;
        }
        return false;
    }

    private boolean hasRepeatedPoint(GeometryCollection gc) {
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g = gc.getGeometryN(i);
            if (!this.hasRepeatedPoint(g)) continue;
            return true;
        }
        return false;
    }
}

