/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.planargraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.util.CGAlgorithms;
import com.vividsolutions.jts.geomgraph.Quadrant;
import com.vividsolutions.jts.planargraph.Edge;
import com.vividsolutions.jts.planargraph.GraphComponent;
import com.vividsolutions.jts.planargraph.Node;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DirectedEdge
extends GraphComponent
implements Comparable<DirectedEdge> {
    protected Edge parentEdge;
    protected Node from;
    protected Node to;
    protected Coordinate p0;
    protected Coordinate p1;
    protected DirectedEdge sym = null;
    protected boolean edgeDirection;
    protected int quadrant;
    protected double angle;

    public static List<Edge> toEdges(Collection<DirectedEdge> dirEdges) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (DirectedEdge de : dirEdges) {
            edges.add(de.parentEdge);
        }
        return edges;
    }

    public DirectedEdge(Node from, Node to, Coordinate directionPt, boolean edgeDirection) {
        this.from = from;
        this.to = to;
        this.edgeDirection = edgeDirection;
        this.p0 = from.getCoordinate();
        this.p1 = directionPt;
        double dx = this.p1.x - this.p0.x;
        double dy = this.p1.y - this.p0.y;
        this.quadrant = Quadrant.quadrant(dx, dy);
        this.angle = Math.atan2(dy, dx);
    }

    public Edge getEdge() {
        return this.parentEdge;
    }

    public void setEdge(Edge parentEdge) {
        this.parentEdge = parentEdge;
    }

    public int getQuadrant() {
        return this.quadrant;
    }

    public Coordinate getDirectionPt() {
        return this.p1;
    }

    public boolean getEdgeDirection() {
        return this.edgeDirection;
    }

    public Node getFromNode() {
        return this.from;
    }

    public Node getToNode() {
        return this.to;
    }

    public Coordinate getCoordinate() {
        return this.from.getCoordinate();
    }

    public double getAngle() {
        return this.angle;
    }

    public DirectedEdge getSym() {
        return this.sym;
    }

    public void setSym(DirectedEdge sym) {
        this.sym = sym;
    }

    void remove() {
        this.sym = null;
        this.parentEdge = null;
    }

    @Override
    public boolean isRemoved() {
        return this.parentEdge == null;
    }

    @Override
    public int compareTo(DirectedEdge e) {
        if (this.quadrant > e.quadrant) {
            return 1;
        }
        if (this.quadrant < e.quadrant) {
            return -1;
        }
        return CGAlgorithms.computeOrientation((Coordinate)e.p0, (Coordinate)e.p1, (Coordinate)this.p1);
    }

    public void print(PrintStream out) {
        String className = this.getClass().getName();
        int lastDotPos = className.lastIndexOf(46);
        String name = className.substring(lastDotPos + 1);
        out.print("  " + name + ": " + this.p0 + " - " + this.p1 + " " + this.quadrant + ":" + this.angle);
    }
}

