/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.planargraph;

import com.vividsolutions.jts.planargraph.DirectedEdge;
import com.vividsolutions.jts.planargraph.Edge;
import com.vividsolutions.jts.planargraph.Node;
import com.vividsolutions.jts.planargraph.NodeMap;
import com.vividsolutions.jts.planargraph.PlanarGraph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Subgraph {
    protected PlanarGraph parentGraph;
    protected Set<Edge> edges = new HashSet<Edge>();
    protected List<DirectedEdge> dirEdges = new ArrayList<DirectedEdge>();
    protected NodeMap nodeMap = new NodeMap();

    public Subgraph(PlanarGraph parentGraph) {
        this.parentGraph = parentGraph;
    }

    public PlanarGraph getParent() {
        return this.parentGraph;
    }

    public void add(Edge e) {
        if (this.edges.contains(e)) {
            return;
        }
        this.edges.add(e);
        this.dirEdges.add(e.getDirEdge(0));
        this.dirEdges.add(e.getDirEdge(1));
        this.nodeMap.add(e.getDirEdge(0).getFromNode());
        this.nodeMap.add(e.getDirEdge(1).getFromNode());
    }

    public Iterator<DirectedEdge> dirEdgeIterator() {
        return this.dirEdges.iterator();
    }

    public Iterator<Edge> edgeIterator() {
        return this.edges.iterator();
    }

    public Iterator<Node> nodeIterator() {
        return this.nodeMap.iterator();
    }

    public boolean contains(Edge e) {
        return this.edges.contains(e);
    }
}

