/*
 * Decompiled with CFR 0.152.
 */
package biz.junginger.freemem;

import biz.junginger.freemem.FreeMemView;
import biz.junginger.freemem.MemorySamples;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class FreeMemPlugin
extends AbstractUIPlugin
implements Runnable {
    public static final String PREF_GC_ON_FOCUS_LOSS = "PREF_GC_ON_FOCUS_LOSS";
    public static final String PREF_AUTO_GC_DELAY = "PREF_AUTO_GC_DELAY";
    public static final String PREF_VIEW_TITLE_IMAGE_WIDTH = "PREF_VIEW_TITLE_IMAGE_WIDTH";
    public static final String PREF_VIEW_USED_MEMORY = "PREF_VIEW_USED_MEMORY_LINE";
    public static final String PREF_VIEW_FREE_MEMORY = "PREF_VIEW_FREE_MEMORY_LINE";
    private static FreeMemPlugin plugin;
    private FreeMemView view;
    private MemorySamples shortSamples = new MemorySamples(60, 1);
    private MemorySamples longSamples = new MemorySamples(120, 60);
    private long deactivationTime;
    private WindowListener winListener = new WindowListener();
    private Thread thread;
    private long lastGcTime;

    public FreeMemPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        this.getWorkbench().addWindowListener((IWindowListener)this.winListener);
        this.thread = new Thread(this);
        this.thread.setName("FreeMem Thread");
        this.thread.setDaemon(true);
        this.thread.start();
        plugin = this;
    }

    public void run() {
        UiUpdater uiUpdater = new UiUpdater();
        while (true) {
            this.checkAutoGc();
            this.doSamplesAndUpdate(uiUpdater);
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void doSamplesAndUpdate(UiUpdater uiUpdater) {
        Composite parent;
        this.shortSamples.sample();
        this.longSamples.sample();
        if (this.view != null && (parent = this.view.getParent()) != null && !parent.isDisposed()) {
            parent.getDisplay().asyncExec((Runnable)uiUpdater);
        }
    }

    private void checkAutoGc() {
        int autoGcDelay;
        if (this.deactivationTime == 0L) {
            return;
        }
        if (!this.getPreferenceStore().getBoolean(PREF_GC_ON_FOCUS_LOSS)) {
            this.deactivationTime = 0L;
            return;
        }
        long now = System.currentTimeMillis();
        long minutes = (now - this.lastGcTime) / 60000L;
        if (minutes < (long)(autoGcDelay = this.getPreferenceStore().getInt(PREF_AUTO_GC_DELAY))) {
            this.deactivationTime = 0L;
            return;
        }
        long time = now - this.deactivationTime;
        if (time > 200L) {
            this.performGc();
            this.deactivationTime = 0L;
        }
    }

    public void performGc() {
        this.shortSamples.trackGcPerformed();
        this.longSamples.trackGcPerformed();
        System.runFinalization();
        System.gc();
        this.lastGcTime = System.currentTimeMillis();
    }

    public static FreeMemPlugin getPlugin() {
        return plugin;
    }

    public MemorySamples getLongSamples() {
        return this.longSamples;
    }

    public MemorySamples getShortSamples() {
        return this.shortSamples;
    }

    public FreeMemView getView() {
        return this.view;
    }

    public void setView(FreeMemView view) {
        this.view = view;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(PREF_GC_ON_FOCUS_LOSS, true);
        store.setDefault(PREF_AUTO_GC_DELAY, 5);
        store.setDefault(PREF_VIEW_TITLE_IMAGE_WIDTH, 32);
        store.setDefault(PREF_VIEW_FREE_MEMORY, false);
        store.setDefault(PREF_VIEW_USED_MEMORY, true);
    }

    private class WindowListener
    implements IWindowListener {
        WindowListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            FreeMemPlugin.this.deactivationTime = System.currentTimeMillis();
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }

    private class UiUpdater
    implements Runnable {
        UiUpdater() {
        }

        public void run() {
            if (FreeMemPlugin.this.view != null) {
                FreeMemPlugin.this.view.updateUI();
            }
        }
    }
}

