/*
 * Decompiled with CFR 0.152.
 */
package biz.junginger.freemem;

import biz.junginger.freemem.FreeMemPlugin;
import biz.junginger.freemem.MemorySamples;
import biz.junginger.freemem.MonitorCanvas;
import biz.junginger.freemem.ViewTitleUpdater;
import biz.junginger.plugin.common.OpenUrlAction;
import biz.junginger.plugin.common.PluginUtils;
import java.lang.reflect.Method;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class FreeMemView
extends ViewPart {
    private static final String URL_PLUGIN_HOME = "http://www.junginger.biz/eclipse";
    private static final String URL_RATE_AT_INFO = "http://eclipse-plugins.info/eclipse/plugin_details.jsp?id=756";
    private static final String URL_RATE_AT_CENTRAL = "http://www.eclipseplugincentral.com/Web_Links+index-req-viewlink-cid-307.html";
    private static final String URL_DONATE_PAYPAL = "http://www.junginger.biz/eclipse/donate-rss-view.html";
    private Action gcAction;
    private Composite parent;
    private ViewTitleUpdater titleUpdater;
    private MonitorCanvas shortMonitor;
    private MonitorCanvas longMonitor;
    private MemorySamples longSamples;
    private MemorySamples shortSamples;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public FreeMemView() {
        long maxMem = Runtime.getRuntime().maxMemory() / 0x100000L;
        String tt = "FreeMem - " + maxMem + "M maximum";
        this.setTitleToolTip(tt);
        this.setTitleV2AndV3("FreeMem");
        this.titleUpdater = new ViewTitleUpdater(this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.makeActions();
        parent.setLayout((Layout)new FillLayout(512));
        this.contributeToActionBars();
        FreeMemPlugin plugin = FreeMemPlugin.getPlugin();
        this.shortSamples = plugin.getShortSamples();
        this.longSamples = plugin.getLongSamples();
        this.shortMonitor = new MonitorCanvas(parent, 0, this.shortSamples);
        this.longMonitor = new MonitorCanvas(parent, 0, this.longSamples);
        plugin.setView(this);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager manager = bars.getMenuManager();
        manager.add((IAction)this.gcAction);
        manager.add((IContributionItem)new Separator());
        IAction prefAction = PluginUtils.createPreferencesAction("biz.junginger.freemem.PreferencesPage");
        if (prefAction != null) {
            manager.add(prefAction);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)new OpenUrlAction(URL_PLUGIN_HOME, "Plugin Homepage"));
        manager.add((IContributionItem)new Separator());
        MenuManager supportMenu = PluginUtils.createSupportMenu(URL_RATE_AT_INFO, URL_RATE_AT_CENTRAL, URL_DONATE_PAYPAL);
        manager.add((IContributionItem)supportMenu);
    }

    private void makeActions() {
        this.gcAction = new Action(){

            public void run() {
                FreeMemPlugin p = FreeMemPlugin.getPlugin();
                if (p != null) {
                    p.performGc();
                }
            }
        };
        this.gcAction.setText("Recycle memory");
        this.gcAction.setToolTipText("Tries to free memory (Garbage collection)");
        ImageDescriptor desc = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/biz/junginger/freemem/recycle-icon.gif");
        this.gcAction.setImageDescriptor(desc);
    }

    public void setFocus() {
    }

    public void setTitleV2AndV3(String text) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] args = classArray;
        try {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.part.ViewPart");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method m = clazz2.getDeclaredMethod("setPartName", args);
            m.setAccessible(true);
            Object[] obj = new Object[]{text};
            m.invoke((Object)this, obj);
        }
        catch (Throwable t) {
            try {
                super.setTitle(text);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setTitleToolTip(String text) {
        super.setTitleToolTip(text);
    }

    public void setTitleImage(Image img) {
        super.setTitleImage(img);
    }

    public Composite getParent() {
        return this.parent;
    }

    public void dispose() {
        this.parent = null;
        super.dispose();
        this.titleUpdater.dispose();
        this.titleUpdater = null;
        this.shortMonitor.dispose();
        this.longMonitor.dispose();
    }

    public MonitorCanvas getShortMonitor() {
        return this.shortMonitor;
    }

    public MonitorCanvas getLongMonitor() {
        return this.longMonitor;
    }

    public void updateUI() {
        if (this.titleUpdater == null) {
            return;
        }
        this.titleUpdater.updateUI();
        IPreferenceStore prefs = FreeMemPlugin.getPlugin().getPreferenceStore();
        boolean free = prefs.getBoolean("PREF_VIEW_FREE_MEMORY_LINE");
        boolean used = prefs.getBoolean("PREF_VIEW_USED_MEMORY_LINE");
        this.shortMonitor.setShowFree(free);
        this.shortMonitor.setShowUsed(used);
        this.longMonitor.setShowFree(free);
        this.longMonitor.setShowUsed(used);
        if (this.shortSamples.hasNewData() && !this.shortMonitor.isDisposed()) {
            this.shortMonitor.redraw();
        }
        if (this.longSamples.hasNewData() && !this.longMonitor.isDisposed()) {
            this.longMonitor.redraw();
        }
    }
}

