/*
 * Decompiled with CFR 0.152.
 */
package biz.junginger.freemem;

import java.io.IOException;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class HyperlinkCreator {
    private static Cursor linkCursor;
    private static Color linkColor;

    static {
        linkColor = new Color(null, 0, 0, 255);
        linkCursor = new Cursor(null, 21);
    }

    public static Text createHyperlink(Composite parent, String text, String url) {
        Text link = new Text(parent, 72);
        link.setForeground(linkColor);
        link.setBackground(parent.getBackground());
        link.setText(text);
        String osName = System.getProperty("os.name");
        if (osName != null && osName.startsWith("Windows")) {
            link.setCursor(linkCursor);
            MyMouseListener myListener = new MyMouseListener(url);
            link.addMouseListener((MouseListener)myListener);
        }
        return link;
    }

    public static Text createHyperlink(Composite parent, String textAndUrl) {
        return HyperlinkCreator.createHyperlink(parent, textAndUrl, textAndUrl);
    }

    private static final class MyMouseListener
    extends MouseAdapter {
        private final String url;

        public MyMouseListener(String url) {
            this.url = url;
        }

        public void mouseDown(MouseEvent e) {
            try {
                String cmd = "rundll32 url.dll,FileProtocolHandler " + this.url;
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

